resource "aws_iam_role" "bs" {
  name = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  path = "/"

  assume_role_policy = <<EOT
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": { "Service": "ec2.amazonaws.com"},
      "Action": "sts:AssumeRole"
    }
  ]
}
EOT
}

resource "aws_iam_role_policy" "bs" {
  name   = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  policy = "${coalesce(var.iam_role_policy, file("${path.module}/files/iam_role"))}"
  role   = "${aws_iam_role.bs.id}"
}

resource "aws_iam_role_policy" "bs_sandstorm" {
  name   = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-sandstorm"
  policy = <<EOT
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "sts:AssumeRole",
      "Resource": [
        "arn:aws:iam::924637445623:role/${coalesce(var.common_name, null_resource.vars.triggers.cn)}",
        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/jax-${var.env}"
      ]
    }
  ]
}
EOT
  role   = "${aws_iam_role.bs.id}"
}

resource "aws_iam_instance_profile" "bs" {
  depends_on = ["aws_iam_role.bs"]
  name       = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  roles      = ["${aws_iam_role.bs.name}"]
}
