resource "aws_elastic_beanstalk_configuration_template" "bs" {
  name                = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-template"
  description         = "placeholder to allow the user to optionally specify a template"
  application         = "${var.eb_application_name}"
  solution_stack_name = "${var.solution_stack_name}"
}

resource "aws_elastic_beanstalk_environment" "bs" {
  name         = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  description  = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  application  = "${var.eb_application_name}"
  tier         = "${var.env_type}"

  tags {
    Name        = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
    Environment = "${var.env}"
    Service     = "${var.service}"
    Owner       = "${var.owner}"
  }

  wait_for_ready_timeout = "${var.wait_for_ready_timeout}"
  template_name          = "${coalesce(var.eb_config_template_name, aws_elastic_beanstalk_configuration_template.bs.name)}"

  # Vpc  and network related settings
  setting {
    namespace = "aws:ec2:vpc"
    name      = "VPCId"
    value     = "${var.vpc_id}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "Subnets"
    value     = "${var.ec2_subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBSubnets"
    value     = "${var.elb_subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "AssociatePublicIpAddress"
    value     = "${var.associate_public_address}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBScheme"
    value     = "${var.elb_scheme}"
  }

  # Load Balancer Related Settings
  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "SecurityGroups"
    value     = "${var.elb_loadbalancer_security_groups}"
  }

  # asg launch configuration settings
  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "IamInstanceProfile"
    value     = "${coalesce(var.auto_scaling_lc_iam_instance_profile, aws_iam_instance_profile.bs.name)}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "InstanceType"
    value     = "${var.auto_scaling_lc_instance_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "MonitoringInterval"
    value     = "${var.auto_scaling_lc_monitoring_interval}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "SecurityGroups"
    value     = "${var.auto_scaling_lc_security_groups}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeType"
    value     = "${var.auto_scaling_lc_root_volume_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeSize"
    value     = "${var.auto_scaling_lc_root_volume_size}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeIOPS"
    value     = "${var.auto_scaling_lc_root_volume_iops}"
  }

  # asg scaling settings

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MinSize"
    value     = "${var.cluster_min_size}"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MinSize"
    value     = "${var.cluster_max_size}"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "MeasureName"
    value     = "CPUUtilization"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "Unit"
    value     = "Percent"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "Statistic"
    value     = "Average"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "UpperThreshold"
    value     = "70"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "UpperBreachScaleIncrement"
    value     = "1"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "LowerThreshold"
    value     = "25"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "LowerBreachScaleIncrement"
    value     = "-1"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "BreachDuration"
    value     = "5"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "Period"
    value     = "1"
  }

  # environment variables

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENV_NAME"
    value     = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-env"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "APP"
    value     = "${var.eb_application_name}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "STATSD_HOST_PORT"
    value     = "${var.statsd_host}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENVIRONMENT"
    value     = "${var.env}"
  }

  # misc

  setting {
    namespace = "aws:elasticbeanstalk:application"
    name      = "Application Healthcheck URL"
    value     = "${var.healthcheck_url}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "SystemType"
    value     = "enhanced"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "DeploymentPolicy"
    value     = "Rolling"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSizeType"
    value     = "Fixed"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSize"
    value     = "1"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "Timeout"
    value     = "60"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateEnabled"
    value     = "true"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "MaxBatchSize"
    value     = "1"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "MinInstancesInService"
    value     = "${var.min_instances_in_service}"
  }

  # eb environment settings
  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "ServiceRole"
    value     = "${var.eb_environment_service_role}"
  }
}
