module "app" {
  source = "../aws_eb_app"
  name = "jax"
  description = "Live streams"
}

module "api" {
  source = "../aws_eb_env"
  service = "web/jax"
  common_name = "jax-staging-api"
  env = "staging"
  owner = "search-and-discovery@justin.tv"
  eb_application_name = "jax"
  vpc_id = "vpc-15e70b72"
  ec2_subnet_ids = "subnet-8fae83f9,subnet-f08d8694,subnet-df3ea487"
  elb_subnet_ids = "subnet-f08d8694,subnet-8fae83f9,subnet-df3ea487"
  elb_loadbalancer_security_groups = "sg-8b58c6f2"
  auto_scaling_lc_security_groups = "sg-8b58c6f2"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_instance_type = "c4.4xlarge"
  healthcheck_url = "/health"
}

module "updater" {
  source = "../aws_eb_env"
  service = "web/jax"
  common_name = "jax-staging-updater"
  env = "staging"
  env_type = "Worker"
  owner = "search-and-discovery@justin.tv"
  eb_application_name = "jax"
  vpc_id = "vpc-15e70b72"
  ec2_subnet_ids = "subnet-8fae83f9,subnet-f08d8694,subnet-df3ea487"
  elb_subnet_ids = "subnet-f08d8694,subnet-8fae83f9,subnet-df3ea487"
  elb_loadbalancer_security_groups = "sg-8b58c6f2"
  auto_scaling_lc_security_groups = "sg-8b58c6f2"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_instance_type = "m4.2xlarge"
  healthcheck_url = "/health"
}