resource "terraform_remote_state" "twitch_discovery_aws" {
  backend = "s3"
  config {
    bucket = "twitch-discovery-aws"
    key = "tfstate/web/terraform/accounts/twitch-discovery-aws"
    region = "us-west-2"
  }
}

provider "aws" {
  region = "us-west-2"
}

module "instance" {
  source = "../aws_es_cluster"
  name = "jax-staging"
  es_instance_type = "r3.xlarge.elasticsearch"
  policy = <<ACCESS_POLICIES
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "*"
      },
      "Action": "es:*",
      "Resource": "arn:aws:es:us-west-2:924637445623:domain/jax-staging/*",
      "Condition": {
        "IpAddress": {
          "aws:SourceIp": [
            "38.104.129.210",
            "54.27.171.53",
            "52.38.13.41",
            "52.41.175.228",
            "10.255.246.58",
            "10.199.140.117",
            "10.199.192.0/18",
            "192.168.0.0/16",
            "12.245.210.118",
            "12.245.210.114",
            "35.160.57.102",
            "35.160.96.93",
            "35.161.95.134",
            "35.161.51.230",
            "35.161.49.138",
            "35.161.76.167"
          ]
        }
      }
    }
  ]
}
ACCESS_POLICIES
}