package mocks

import kinesis "github.com/aws/aws-sdk-go/service/kinesis"
import mock "github.com/stretchr/testify/mock"
import updaterkinesis "code.justin.tv/web/jax/updater/kinesis"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// GetRecordsChannel provides a mock function with given fields:
func (_m *Client) GetRecordsChannel() (chan *kinesis.GetRecordsOutput, error) {
	ret := _m.Called()

	var r0 chan *kinesis.GetRecordsOutput
	if rf, ok := ret.Get(0).(func() chan *kinesis.GetRecordsOutput); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan *kinesis.GetRecordsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PublishStreams provides a mock function with given fields: chs
func (_m *Client) PublishStreams(chs []updaterkinesis.Channel) error {
	ret := _m.Called(chs)

	var r0 error
	if rf, ok := ret.Get(0).(func([]updaterkinesis.Channel) error); ok {
		r0 = rf(chs)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ updaterkinesis.Client = (*Client)(nil)
