package updater

import (
	"testing"

	"code.justin.tv/web/jax/common/config"
	"code.justin.tv/web/jax/common/stats"

	. "github.com/smartystreets/goconvey/convey"
)

func TestChannelsConvertExample(t *testing.T) {
	exp := map[string]interface{}{
		"channel":              `"wickd"`,
		"channel_id":           `38865245`,
		"meta_game":            `"League of Legends"`,
		"title":                `"Wickd vs Soaz 1v1 allstar spot challenge!"`,
		"directory_hidden":     `false`,
		"broadcaster_language": `"en"`,
		"game_id":              `123`,
	}

	c := &channelsUpdater{}
	conf := &config.Config{
		Environment:   "development",
		StatsHostPort: "graphite.internal.justin.tv:8125",
		ChannelsHost:  "users-service.prod.us-west2.twitch.tv:80",
	}
	stats := stats.InitStatsd(conf)
	c.Init(conf, stats)
	out, err := c.convert([]byte(channelsProps))
	Convey("When converting the sample data", t, func() {
		Convey("Error should be nil", func() {
			So(err, ShouldBeNil)
		})
		Convey("There should be exactly one channel", func() {
			So(len(out), ShouldEqual, 1)
		})

		ch, ok := out["wickd"]
		Convey("Which corresponds to the entry 'wickd'", func() {
			So(ok, ShouldBeTrue)
		})
		intf, ok := ch["rails"]
		Convey("Which should have a subgroup for 'rails'", func() {
			So(ok, ShouldBeTrue)
		})
		props, ok := intf.(map[string]interface{})
		Convey("And channels is in turn a map[string]interface{}", func() {
			So(ok, ShouldBeTrue)
		})
		Convey("Which matches the expected output", func() {
			for key, val := range exp {
				So(val, ShouldEqual, props[key])
			}
		})
	})

}

var channelsProps = `{"results":[{` +
	`"game":"League of Legends",` +
	`"status":"Wickd vs Soaz 1v1 allstar spot challenge!",` +
	`"broadcaster_language":"en",` +
	`"game_id":123,` +
	`"id":38865245,` +
	`"name":"wickd",` +
	`"directory_hidden":false` +
	`}]}`
