package updater

import (
	"testing"

	"code.justin.tv/web/jax/common/config"
	"code.justin.tv/web/jax/common/stats"

	. "github.com/smartystreets/goconvey/convey"
)

func TestRailsConvertExample(t *testing.T) {
	exp := map[string]interface{}{
		"channel":    `"wickd"`,
		"channel_id": `38865245`,

		"category": `"gaming"`,

		"language": `"en"`,
	}

	r := &railsUpdater{}
	conf := &config.Config{
		Environment:   "development",
		StatsHostPort: "graphite.internal.justin.tv:8125",
	}
	stats := stats.InitStatsd(conf)
	r.Init(conf, stats)
	out, err := r.convert([]byte(railsProps))
	Convey("When converting the sample data", t, func() {
		Convey("Error should be nil", func() {
			So(err, ShouldBeNil)
		})
		Convey("There should be exactly one channel", func() {
			So(len(out), ShouldEqual, 1)
		})
		ch, ok := out["wickd"]
		Convey("Which corresponds to the entry 'wickd'", func() {
			So(ok, ShouldBeTrue)
		})
		intf, ok := ch["rails"]
		Convey("Which should have a subgroup for 'rails'", func() {
			So(ok, ShouldBeTrue)
		})
		props, ok := intf.(map[string]interface{})
		Convey("And rails is in turn a map[string]interface{}", func() {
			So(ok, ShouldBeTrue)
		})
		Convey("Which matches the expected output", func() {
			for key, val := range exp {
				So(val, ShouldEqual, props[key])
			}
		})
	})

}

var railsProps = `[{` +
	`"display_name":"wickd",` +
	`"category":"gaming",` +
	`"language":"en",` +
	`"id":38865245,` +
	`"login":"wickd"` +
	`}]`
