package updater

import (
	"testing"

	"code.justin.tv/web/jax/common/config"
	"code.justin.tv/web/jax/common/stats"

	. "github.com/smartystreets/goconvey/convey"
)

func TestUsherConvertExample(t *testing.T) {
	exp := map[string]interface{}{
		"broadcast_part": `3`,
		"id":             `5396850416`,

		"channel_count": `131594`,

		"video_codec":   `"AVC"`,
		"video_bitrate": `1276.453125`,
		"video_height":  `1080`,
		"video_width":   `1920`,

		"updated_on": `"2013-04-15T14:33:11Z"`,
	}

	u := &usherUpdater{}
	conf := &config.Config{
		Environment:   "development",
		StatsHostPort: "graphite.internal.justin.tv:8125",
	}
	stats := stats.InitStatsd(conf)
	u.Init(conf, stats)
	out, err := u.convert([]byte(usherProps))
	Convey("When converting the sample data", t, func() {
		Convey("Error should be nil", func() {
			So(err, ShouldBeNil)
		})
		Convey("There should be exactly one channel", func() {
			So(len(out), ShouldEqual, 1)
		})
		ch, ok := out["wickd"]
		Convey("Which corresponds to the entry 'wickd'", func() {
			So(ok, ShouldBeTrue)
		})
		intf, ok := ch["usher"]
		Convey("Which should have a subgroup for 'usher'", func() {
			So(ok, ShouldBeTrue)
		})
		props, ok := intf.(map[string]interface{})
		Convey("And usher is in turn a map[string]interface{}", func() {
			So(ok, ShouldBeTrue)
		})
		Convey("Which matches the expected output", func() {
			for key, val := range exp {
				So(val, ShouldEqual, props[key])
			}
		})
	})
}

var usherProps = `[` +
	`{"stream_type": "live",` +
	` "broadcast_part": 3,` +
	` "origin_only": false,` +
	` "channel_subscription": true,` +
	` "audio_codec": "uncompressed",` +
	` "partner": true,` +
	` "ready": true,` +
	` "id": 5396850416,` +
	` "category": "gaming",` +
	` "video_width": 1920,` +
	` "title": "Wickd vs Soaz 1v1 allstar spot challenge!",` +
	` "stats_email": "kevin@justin.tv",` +
	` "video_height": 1080,` +
	` "instant_replicate": false,` +
	` "recorder": 3895568,` +
	` "site_count": 50353,` +
	` "channel": "wickd",` +
	` "up_time": "2013-04-15T13:32:15Z",` +
	` "meta_game": "League of Legends",` +
	` "format": "live",` +
	` "channel_count": 131594,` +
	` "embed_count": 3638,` +
	` "archive_system_version": 1,` +
	` "delay_length": 0,` +
	` "flows": "/stream/flows/5396850416.json",` +
	` "updated_on": "2013-04-15T14:33:11Z",` +
	` "directory_hidden": false,` +
	` "killed": false,` +
	` "unfindable": false,` +
	` "embed_ratio": 0.12108100911935032,` +
	` "name": "live_user_wickd",` +
	` "language": "en",` +
	` "stream_count": 53991,` +
	` "type": "stream",` +
	` "video_bitrate": 1276.453125,` +
	` "origin_name": "video93-1",` +
	` "persistent": "t",` +
	` "channel_id": 38865245,` +
	` "video_codec": "AVC",` +
	` "channel_view_count": 9564803,` +
	` "broadcaster": "obs"}` +
	`]`
