package updater

import (
	"testing"

	"code.justin.tv/web/jax/common/config"
	"code.justin.tv/web/jax/common/stats"

	. "github.com/smartystreets/goconvey/convey"
)

func TestSpadeEventsExample(t *testing.T) {
	out := map[string]XboxProperties{
		"foo": XboxProperties{
			LiveBroadcastID: 123,
			Login:           "foo",
		},
	}

	x := &xboxUpdater{}

	conf := &config.Config{
		Environment:   "development",
		StatsHostPort: "graphite.internal.justin.tv:8125",
	}
	stats := stats.InitStatsd(conf)
	x.Init(conf, stats)
	err := x.sendSpadeTracking(out)

	Convey("When sending spade tracking data", t, func() {
		Convey("Error should be nil", func() {
			So(err, ShouldBeNil)
		})
	})
}
