# upload-service

This service handles user uploaded content.

Most of our docs are on the wiki:
- [Generic Upload Service](https://wiki.twitch.com/display/ENG/Generic+upload+service)
- [Contributing Guide](https://wiki.twitch.com/display/ENG/Generic+Upload+Service+Contributing+Guide)
- [Oncall Runbook](https://wiki.twitch.com/display/ENG/Generic+Upload+Service+Oncall+Runbook)

In the olden dark ages, user-uploaded images were restricted to profile and team images, both which both used the
built-in Rails mechanics to get these picture into our system. Now we moved towards SOA and are building more
features which require custom user input, and there's no solidified and especially safe way of ingesting files
from our users. Sending large chunks of data (like images or video) through Visage would be harmful to the
intended use-case of quick API requests.

Full design: (https://docs.google.com/document/d/1Ss6Pzi3RqLzysswsXrj94-IiKKQRl_CRwFLL_tIKJ64/edit)

### Endpoints
Staging: http://staging-web-upload-service.staging.us-west2.twitch.tv \
Prod: http://prod-web-upload-service.prod.us-west2.twitch.tv

### Versioning

Most of the functionality in this repo can be modified without affecting external parties. However, this is not
the case for the twirp client code and the data formats that are used to communicate with integrating services.
This includes:

##### Client code
The client code covers all changes to the protobuf file rpc/uploader/service.proto and subsequently the two files
generated from it, rpc/uploader/service.pb.go and rpc/uploader/service.twirp.go
This is the go code to use the twirp client and the data structures that will be passed to it. The data structures
define the possible validations and transformations. File name parameter expansion is included in this category
as well.

##### Callback data
The expected output of the upload service is the SNS callback when the processing has completed. The data sent will
be a json-encoded string of the SNSCallback struct defined in models/callback.go

##### Monitoring
Integrating services can use the monitoring fields to specify methods for the upload service to communicate the status
of their uploads. This category includes the formatting of the grafana stat name and the format of the json message
published to SNS on error.

The major version will be incremented on backwards incompatable changes (e.g. renaming the UploadRequest fields)
The minor version will be incremented on new backwards compatable functionality (e.g. adding a new transformation)
The patch version will be incremented on small, backwards compatable bugfixes
http://semver.org/
