package api

import (
	"context"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/common/twirp"
	"code.justin.tv/web/upload-service/api/worker"
	"code.justin.tv/web/upload-service/backend/mocks"
	"code.justin.tv/web/upload-service/rpc/uploader"

	goji "goji.io"

	"github.com/cactus/go-statsd-client/statsd"
	"github.com/stretchr/testify/suite"
)

type ServerTestSuite struct {
	suite.Suite
	backender  *mocks.Backender
	testServer *httptest.Server
}

func (suite *ServerTestSuite) SetupTest() {
	suite.backender = &mocks.Backender{}
	suite.backender.On("EC2InstanceID").Return("")

	mux := goji.NewMux()
	NewServerWithWorker(mux, &worker.Worker{suite.backender, &statsd.NoopClient{}, nil, nil, nil, nil, nil})
	suite.testServer = httptest.NewServer(mux)
}

func (suite *ServerTestSuite) TearDownTest() {
	suite.testServer.Close()
}

func (suite *ServerTestSuite) TestHealthcheck() {
	resp, err := http.Get(suite.testServer.URL + "/health")
	suite.Require().NoError(err)
	suite.Require().Equal(resp.StatusCode, 200)
}

// Doesn't matter how Twirpp responds, just that it does
func (suite *ServerTestSuite) TestTwirp() {
	client := uploader.NewUploaderProtobufClient(suite.testServer.URL, &http.Client{})
	request := &uploader.UploadRequest{}

	_, err := client.Create(context.Background(), request)
	err, success := err.(twirp.Error)
	suite.Require().True(success)
}

func TestServer(t *testing.T) {
	suite.Run(t, new(ServerTestSuite))
}
