package worker

import (
	"testing"

	"github.com/pkg/errors"

	"code.justin.tv/web/upload-service/backend/mocks"

	"code.justin.tv/web/upload-service/rpc/uploader"
	"github.com/stretchr/testify/suite"
)

type ErrorsTestSuite struct {
	suite.Suite
	backender *mocks.Backender
	worker    *Worker
}

func (suite *ErrorsTestSuite) SetupTest() {
	suite.backender = &mocks.Backender{}
	suite.worker = &Worker{Backend: suite.backender}
}

func (suite *ErrorsTestSuite) TestStatusNil() {
	suite.Require().Equal(uploader.Status_POSTPROCESS_COMPLETE, Status(nil))
}

func (suite *ErrorsTestSuite) TestStatusDefault() {
	err := errors.New("no status info")
	suite.Require().Equal(uploader.Status_PROCESSING_FAILED, Status(err))
}

func (suite *ErrorsTestSuite) TestStatusDirect() {
	err := WithStatus(errors.New("foo"), uploader.Status_TRANSFORMATION_FAILED)
	suite.Require().Equal(uploader.Status_TRANSFORMATION_FAILED, Status(err))
}

func (suite *ErrorsTestSuite) TestStatusWrapped() {
	err := errors.Wrap(
		WithStatus(errors.New("foo"), uploader.Status_IMAGE_FORMAT_VALIDATION_FAILED),
		"i am a wrapper",
	)
	suite.Require().Equal(uploader.Status_IMAGE_FORMAT_VALIDATION_FAILED, Status(err))
}

func TestErrors(t *testing.T) {
	suite.Run(t, new(ErrorsTestSuite))
}
