package worker

import (
	"errors"
	"strconv"
	"testing"

	"code.justin.tv/web/upload-service/api/worker/mocks"

	"github.com/stretchr/testify/suite"
)

type RollbarTestSuite struct {
	suite.Suite
}

func (suite *RollbarTestSuite) TestNilRollbar() {
	suite.Require().Nil(NewRollbarWrapper(nil))
}

// TestRollbar ensures that the RollbarWrapper implementation is blocking at the appropriate times
// to avoid race conditions.
func (suite *RollbarTestSuite) TestRollbar() {
	mock := mocks.NewRollbarMock()
	rollbar := NewAbstractRollbarWrapper(mock, 100)

	testNum := 5

	for i := 0; i < testNum; i++ {
		numStr := strconv.Itoa(i)
		rollbar.QueueRollbar("token "+numStr, errors.New("error "+numStr), "uploadID "+numStr)
	}
	for i := 0; i < testNum; i++ {
		<-mock.SignalStart
		mock.NetworkDelay <- struct{}{}
		<-mock.SignalEnd
	}

	for i := 0; i < testNum; i++ {
		numStr := strconv.Itoa(i)
		suite.Require().Equal("token "+numStr, mock.ReconstructedMsgs[i].Token)
		suite.Require().Equal("error "+numStr, mock.ReconstructedMsgs[i].Body)
	}
	close(mock.BodyChannel)
}

func TestRollbar(t *testing.T) {
	suite.Run(t, new(RollbarTestSuite))
}
