package awsmocks

import aws "github.com/aws/aws-sdk-go/aws"
import dynamodb "github.com/aws/aws-sdk-go/service/dynamodb"

import mock "github.com/stretchr/testify/mock"
import request "github.com/aws/aws-sdk-go/aws/request"

// DynamoDBAPI is an autogenerated mock type for the DynamoDBAPI type
type DynamoDBAPI struct {
	mock.Mock
}

// BatchGetItem provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) BatchGetItem(_a0 *dynamodb.BatchGetItemInput) (*dynamodb.BatchGetItemOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.BatchGetItemOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.BatchGetItemInput) *dynamodb.BatchGetItemOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.BatchGetItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.BatchGetItemInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// BatchGetItemPages provides a mock function with given fields: _a0, _a1
func (_m *DynamoDBAPI) BatchGetItemPages(_a0 *dynamodb.BatchGetItemInput, _a1 func(*dynamodb.BatchGetItemOutput, bool) bool) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(*dynamodb.BatchGetItemInput, func(*dynamodb.BatchGetItemOutput, bool) bool) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// BatchGetItemPagesWithContext provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *DynamoDBAPI) BatchGetItemPagesWithContext(_a0 aws.Context, _a1 *dynamodb.BatchGetItemInput, _a2 func(*dynamodb.BatchGetItemOutput, bool) bool, _a3 ...request.Option) error {
	_va := make([]interface{}, len(_a3))
	for _i := range _a3 {
		_va[_i] = _a3[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1, _a2)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.BatchGetItemInput, func(*dynamodb.BatchGetItemOutput, bool) bool, ...request.Option) error); ok {
		r0 = rf(_a0, _a1, _a2, _a3...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// BatchGetItemRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) BatchGetItemRequest(_a0 *dynamodb.BatchGetItemInput) (*request.Request, *dynamodb.BatchGetItemOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.BatchGetItemInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.BatchGetItemOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.BatchGetItemInput) *dynamodb.BatchGetItemOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.BatchGetItemOutput)
		}
	}

	return r0, r1
}

// BatchGetItemWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) BatchGetItemWithContext(_a0 aws.Context, _a1 *dynamodb.BatchGetItemInput, _a2 ...request.Option) (*dynamodb.BatchGetItemOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.BatchGetItemOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.BatchGetItemInput, ...request.Option) *dynamodb.BatchGetItemOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.BatchGetItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.BatchGetItemInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// BatchWriteItem provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) BatchWriteItem(_a0 *dynamodb.BatchWriteItemInput) (*dynamodb.BatchWriteItemOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.BatchWriteItemOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.BatchWriteItemInput) *dynamodb.BatchWriteItemOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.BatchWriteItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.BatchWriteItemInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// BatchWriteItemRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) BatchWriteItemRequest(_a0 *dynamodb.BatchWriteItemInput) (*request.Request, *dynamodb.BatchWriteItemOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.BatchWriteItemInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.BatchWriteItemOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.BatchWriteItemInput) *dynamodb.BatchWriteItemOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.BatchWriteItemOutput)
		}
	}

	return r0, r1
}

// BatchWriteItemWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) BatchWriteItemWithContext(_a0 aws.Context, _a1 *dynamodb.BatchWriteItemInput, _a2 ...request.Option) (*dynamodb.BatchWriteItemOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.BatchWriteItemOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.BatchWriteItemInput, ...request.Option) *dynamodb.BatchWriteItemOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.BatchWriteItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.BatchWriteItemInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateTable provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) CreateTable(_a0 *dynamodb.CreateTableInput) (*dynamodb.CreateTableOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.CreateTableOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.CreateTableInput) *dynamodb.CreateTableOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.CreateTableOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.CreateTableInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateTableRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) CreateTableRequest(_a0 *dynamodb.CreateTableInput) (*request.Request, *dynamodb.CreateTableOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.CreateTableInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.CreateTableOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.CreateTableInput) *dynamodb.CreateTableOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.CreateTableOutput)
		}
	}

	return r0, r1
}

// CreateTableWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) CreateTableWithContext(_a0 aws.Context, _a1 *dynamodb.CreateTableInput, _a2 ...request.Option) (*dynamodb.CreateTableOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.CreateTableOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.CreateTableInput, ...request.Option) *dynamodb.CreateTableOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.CreateTableOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.CreateTableInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteItem provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DeleteItem(_a0 *dynamodb.DeleteItemInput) (*dynamodb.DeleteItemOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.DeleteItemOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.DeleteItemInput) *dynamodb.DeleteItemOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DeleteItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.DeleteItemInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteItemRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DeleteItemRequest(_a0 *dynamodb.DeleteItemInput) (*request.Request, *dynamodb.DeleteItemOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.DeleteItemInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.DeleteItemOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.DeleteItemInput) *dynamodb.DeleteItemOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.DeleteItemOutput)
		}
	}

	return r0, r1
}

// DeleteItemWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) DeleteItemWithContext(_a0 aws.Context, _a1 *dynamodb.DeleteItemInput, _a2 ...request.Option) (*dynamodb.DeleteItemOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.DeleteItemOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.DeleteItemInput, ...request.Option) *dynamodb.DeleteItemOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DeleteItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.DeleteItemInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteTable provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DeleteTable(_a0 *dynamodb.DeleteTableInput) (*dynamodb.DeleteTableOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.DeleteTableOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.DeleteTableInput) *dynamodb.DeleteTableOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DeleteTableOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.DeleteTableInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteTableRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DeleteTableRequest(_a0 *dynamodb.DeleteTableInput) (*request.Request, *dynamodb.DeleteTableOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.DeleteTableInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.DeleteTableOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.DeleteTableInput) *dynamodb.DeleteTableOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.DeleteTableOutput)
		}
	}

	return r0, r1
}

// DeleteTableWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) DeleteTableWithContext(_a0 aws.Context, _a1 *dynamodb.DeleteTableInput, _a2 ...request.Option) (*dynamodb.DeleteTableOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.DeleteTableOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.DeleteTableInput, ...request.Option) *dynamodb.DeleteTableOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DeleteTableOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.DeleteTableInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeLimits provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DescribeLimits(_a0 *dynamodb.DescribeLimitsInput) (*dynamodb.DescribeLimitsOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.DescribeLimitsOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.DescribeLimitsInput) *dynamodb.DescribeLimitsOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DescribeLimitsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.DescribeLimitsInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeLimitsRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DescribeLimitsRequest(_a0 *dynamodb.DescribeLimitsInput) (*request.Request, *dynamodb.DescribeLimitsOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.DescribeLimitsInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.DescribeLimitsOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.DescribeLimitsInput) *dynamodb.DescribeLimitsOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.DescribeLimitsOutput)
		}
	}

	return r0, r1
}

// DescribeLimitsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) DescribeLimitsWithContext(_a0 aws.Context, _a1 *dynamodb.DescribeLimitsInput, _a2 ...request.Option) (*dynamodb.DescribeLimitsOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.DescribeLimitsOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.DescribeLimitsInput, ...request.Option) *dynamodb.DescribeLimitsOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DescribeLimitsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.DescribeLimitsInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeTable provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DescribeTable(_a0 *dynamodb.DescribeTableInput) (*dynamodb.DescribeTableOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.DescribeTableOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.DescribeTableInput) *dynamodb.DescribeTableOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DescribeTableOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.DescribeTableInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeTableRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DescribeTableRequest(_a0 *dynamodb.DescribeTableInput) (*request.Request, *dynamodb.DescribeTableOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.DescribeTableInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.DescribeTableOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.DescribeTableInput) *dynamodb.DescribeTableOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.DescribeTableOutput)
		}
	}

	return r0, r1
}

// DescribeTableWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) DescribeTableWithContext(_a0 aws.Context, _a1 *dynamodb.DescribeTableInput, _a2 ...request.Option) (*dynamodb.DescribeTableOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.DescribeTableOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.DescribeTableInput, ...request.Option) *dynamodb.DescribeTableOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DescribeTableOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.DescribeTableInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeTimeToLive provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DescribeTimeToLive(_a0 *dynamodb.DescribeTimeToLiveInput) (*dynamodb.DescribeTimeToLiveOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.DescribeTimeToLiveOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.DescribeTimeToLiveInput) *dynamodb.DescribeTimeToLiveOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DescribeTimeToLiveOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.DescribeTimeToLiveInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeTimeToLiveRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) DescribeTimeToLiveRequest(_a0 *dynamodb.DescribeTimeToLiveInput) (*request.Request, *dynamodb.DescribeTimeToLiveOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.DescribeTimeToLiveInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.DescribeTimeToLiveOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.DescribeTimeToLiveInput) *dynamodb.DescribeTimeToLiveOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.DescribeTimeToLiveOutput)
		}
	}

	return r0, r1
}

// DescribeTimeToLiveWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) DescribeTimeToLiveWithContext(_a0 aws.Context, _a1 *dynamodb.DescribeTimeToLiveInput, _a2 ...request.Option) (*dynamodb.DescribeTimeToLiveOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.DescribeTimeToLiveOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.DescribeTimeToLiveInput, ...request.Option) *dynamodb.DescribeTimeToLiveOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.DescribeTimeToLiveOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.DescribeTimeToLiveInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetItem provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) GetItem(_a0 *dynamodb.GetItemInput) (*dynamodb.GetItemOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.GetItemOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.GetItemInput) *dynamodb.GetItemOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.GetItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.GetItemInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetItemRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) GetItemRequest(_a0 *dynamodb.GetItemInput) (*request.Request, *dynamodb.GetItemOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.GetItemInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.GetItemOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.GetItemInput) *dynamodb.GetItemOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.GetItemOutput)
		}
	}

	return r0, r1
}

// GetItemWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) GetItemWithContext(_a0 aws.Context, _a1 *dynamodb.GetItemInput, _a2 ...request.Option) (*dynamodb.GetItemOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.GetItemOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.GetItemInput, ...request.Option) *dynamodb.GetItemOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.GetItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.GetItemInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListTables provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) ListTables(_a0 *dynamodb.ListTablesInput) (*dynamodb.ListTablesOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.ListTablesOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.ListTablesInput) *dynamodb.ListTablesOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.ListTablesOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.ListTablesInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListTablesPages provides a mock function with given fields: _a0, _a1
func (_m *DynamoDBAPI) ListTablesPages(_a0 *dynamodb.ListTablesInput, _a1 func(*dynamodb.ListTablesOutput, bool) bool) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(*dynamodb.ListTablesInput, func(*dynamodb.ListTablesOutput, bool) bool) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ListTablesPagesWithContext provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *DynamoDBAPI) ListTablesPagesWithContext(_a0 aws.Context, _a1 *dynamodb.ListTablesInput, _a2 func(*dynamodb.ListTablesOutput, bool) bool, _a3 ...request.Option) error {
	_va := make([]interface{}, len(_a3))
	for _i := range _a3 {
		_va[_i] = _a3[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1, _a2)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.ListTablesInput, func(*dynamodb.ListTablesOutput, bool) bool, ...request.Option) error); ok {
		r0 = rf(_a0, _a1, _a2, _a3...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ListTablesRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) ListTablesRequest(_a0 *dynamodb.ListTablesInput) (*request.Request, *dynamodb.ListTablesOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.ListTablesInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.ListTablesOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.ListTablesInput) *dynamodb.ListTablesOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.ListTablesOutput)
		}
	}

	return r0, r1
}

// ListTablesWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) ListTablesWithContext(_a0 aws.Context, _a1 *dynamodb.ListTablesInput, _a2 ...request.Option) (*dynamodb.ListTablesOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.ListTablesOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.ListTablesInput, ...request.Option) *dynamodb.ListTablesOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.ListTablesOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.ListTablesInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListTagsOfResource provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) ListTagsOfResource(_a0 *dynamodb.ListTagsOfResourceInput) (*dynamodb.ListTagsOfResourceOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.ListTagsOfResourceOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.ListTagsOfResourceInput) *dynamodb.ListTagsOfResourceOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.ListTagsOfResourceOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.ListTagsOfResourceInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListTagsOfResourceRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) ListTagsOfResourceRequest(_a0 *dynamodb.ListTagsOfResourceInput) (*request.Request, *dynamodb.ListTagsOfResourceOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.ListTagsOfResourceInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.ListTagsOfResourceOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.ListTagsOfResourceInput) *dynamodb.ListTagsOfResourceOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.ListTagsOfResourceOutput)
		}
	}

	return r0, r1
}

// ListTagsOfResourceWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) ListTagsOfResourceWithContext(_a0 aws.Context, _a1 *dynamodb.ListTagsOfResourceInput, _a2 ...request.Option) (*dynamodb.ListTagsOfResourceOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.ListTagsOfResourceOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.ListTagsOfResourceInput, ...request.Option) *dynamodb.ListTagsOfResourceOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.ListTagsOfResourceOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.ListTagsOfResourceInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PutItem provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) PutItem(_a0 *dynamodb.PutItemInput) (*dynamodb.PutItemOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.PutItemOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.PutItemInput) *dynamodb.PutItemOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.PutItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.PutItemInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PutItemRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) PutItemRequest(_a0 *dynamodb.PutItemInput) (*request.Request, *dynamodb.PutItemOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.PutItemInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.PutItemOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.PutItemInput) *dynamodb.PutItemOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.PutItemOutput)
		}
	}

	return r0, r1
}

// PutItemWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) PutItemWithContext(_a0 aws.Context, _a1 *dynamodb.PutItemInput, _a2 ...request.Option) (*dynamodb.PutItemOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.PutItemOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.PutItemInput, ...request.Option) *dynamodb.PutItemOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.PutItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.PutItemInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Query provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) Query(_a0 *dynamodb.QueryInput) (*dynamodb.QueryOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.QueryOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.QueryInput) *dynamodb.QueryOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.QueryOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.QueryInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// QueryPages provides a mock function with given fields: _a0, _a1
func (_m *DynamoDBAPI) QueryPages(_a0 *dynamodb.QueryInput, _a1 func(*dynamodb.QueryOutput, bool) bool) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(*dynamodb.QueryInput, func(*dynamodb.QueryOutput, bool) bool) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// QueryPagesWithContext provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *DynamoDBAPI) QueryPagesWithContext(_a0 aws.Context, _a1 *dynamodb.QueryInput, _a2 func(*dynamodb.QueryOutput, bool) bool, _a3 ...request.Option) error {
	_va := make([]interface{}, len(_a3))
	for _i := range _a3 {
		_va[_i] = _a3[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1, _a2)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.QueryInput, func(*dynamodb.QueryOutput, bool) bool, ...request.Option) error); ok {
		r0 = rf(_a0, _a1, _a2, _a3...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// QueryRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) QueryRequest(_a0 *dynamodb.QueryInput) (*request.Request, *dynamodb.QueryOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.QueryInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.QueryOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.QueryInput) *dynamodb.QueryOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.QueryOutput)
		}
	}

	return r0, r1
}

// QueryWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) QueryWithContext(_a0 aws.Context, _a1 *dynamodb.QueryInput, _a2 ...request.Option) (*dynamodb.QueryOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.QueryOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.QueryInput, ...request.Option) *dynamodb.QueryOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.QueryOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.QueryInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Scan provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) Scan(_a0 *dynamodb.ScanInput) (*dynamodb.ScanOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.ScanOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.ScanInput) *dynamodb.ScanOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.ScanOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.ScanInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ScanPages provides a mock function with given fields: _a0, _a1
func (_m *DynamoDBAPI) ScanPages(_a0 *dynamodb.ScanInput, _a1 func(*dynamodb.ScanOutput, bool) bool) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(*dynamodb.ScanInput, func(*dynamodb.ScanOutput, bool) bool) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ScanPagesWithContext provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *DynamoDBAPI) ScanPagesWithContext(_a0 aws.Context, _a1 *dynamodb.ScanInput, _a2 func(*dynamodb.ScanOutput, bool) bool, _a3 ...request.Option) error {
	_va := make([]interface{}, len(_a3))
	for _i := range _a3 {
		_va[_i] = _a3[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1, _a2)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.ScanInput, func(*dynamodb.ScanOutput, bool) bool, ...request.Option) error); ok {
		r0 = rf(_a0, _a1, _a2, _a3...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ScanRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) ScanRequest(_a0 *dynamodb.ScanInput) (*request.Request, *dynamodb.ScanOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.ScanInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.ScanOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.ScanInput) *dynamodb.ScanOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.ScanOutput)
		}
	}

	return r0, r1
}

// ScanWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) ScanWithContext(_a0 aws.Context, _a1 *dynamodb.ScanInput, _a2 ...request.Option) (*dynamodb.ScanOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.ScanOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.ScanInput, ...request.Option) *dynamodb.ScanOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.ScanOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.ScanInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// TagResource provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) TagResource(_a0 *dynamodb.TagResourceInput) (*dynamodb.TagResourceOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.TagResourceOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.TagResourceInput) *dynamodb.TagResourceOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.TagResourceOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.TagResourceInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// TagResourceRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) TagResourceRequest(_a0 *dynamodb.TagResourceInput) (*request.Request, *dynamodb.TagResourceOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.TagResourceInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.TagResourceOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.TagResourceInput) *dynamodb.TagResourceOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.TagResourceOutput)
		}
	}

	return r0, r1
}

// TagResourceWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) TagResourceWithContext(_a0 aws.Context, _a1 *dynamodb.TagResourceInput, _a2 ...request.Option) (*dynamodb.TagResourceOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.TagResourceOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.TagResourceInput, ...request.Option) *dynamodb.TagResourceOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.TagResourceOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.TagResourceInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UntagResource provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) UntagResource(_a0 *dynamodb.UntagResourceInput) (*dynamodb.UntagResourceOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.UntagResourceOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.UntagResourceInput) *dynamodb.UntagResourceOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.UntagResourceOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.UntagResourceInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UntagResourceRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) UntagResourceRequest(_a0 *dynamodb.UntagResourceInput) (*request.Request, *dynamodb.UntagResourceOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.UntagResourceInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.UntagResourceOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.UntagResourceInput) *dynamodb.UntagResourceOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.UntagResourceOutput)
		}
	}

	return r0, r1
}

// UntagResourceWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) UntagResourceWithContext(_a0 aws.Context, _a1 *dynamodb.UntagResourceInput, _a2 ...request.Option) (*dynamodb.UntagResourceOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.UntagResourceOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.UntagResourceInput, ...request.Option) *dynamodb.UntagResourceOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.UntagResourceOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.UntagResourceInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateItem provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) UpdateItem(_a0 *dynamodb.UpdateItemInput) (*dynamodb.UpdateItemOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.UpdateItemOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.UpdateItemInput) *dynamodb.UpdateItemOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.UpdateItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.UpdateItemInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateItemRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) UpdateItemRequest(_a0 *dynamodb.UpdateItemInput) (*request.Request, *dynamodb.UpdateItemOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.UpdateItemInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.UpdateItemOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.UpdateItemInput) *dynamodb.UpdateItemOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.UpdateItemOutput)
		}
	}

	return r0, r1
}

// UpdateItemWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) UpdateItemWithContext(_a0 aws.Context, _a1 *dynamodb.UpdateItemInput, _a2 ...request.Option) (*dynamodb.UpdateItemOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.UpdateItemOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.UpdateItemInput, ...request.Option) *dynamodb.UpdateItemOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.UpdateItemOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.UpdateItemInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateTable provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) UpdateTable(_a0 *dynamodb.UpdateTableInput) (*dynamodb.UpdateTableOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.UpdateTableOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.UpdateTableInput) *dynamodb.UpdateTableOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.UpdateTableOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.UpdateTableInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateTableRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) UpdateTableRequest(_a0 *dynamodb.UpdateTableInput) (*request.Request, *dynamodb.UpdateTableOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.UpdateTableInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.UpdateTableOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.UpdateTableInput) *dynamodb.UpdateTableOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.UpdateTableOutput)
		}
	}

	return r0, r1
}

// UpdateTableWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) UpdateTableWithContext(_a0 aws.Context, _a1 *dynamodb.UpdateTableInput, _a2 ...request.Option) (*dynamodb.UpdateTableOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.UpdateTableOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.UpdateTableInput, ...request.Option) *dynamodb.UpdateTableOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.UpdateTableOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.UpdateTableInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateTimeToLive provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) UpdateTimeToLive(_a0 *dynamodb.UpdateTimeToLiveInput) (*dynamodb.UpdateTimeToLiveOutput, error) {
	ret := _m.Called(_a0)

	var r0 *dynamodb.UpdateTimeToLiveOutput
	if rf, ok := ret.Get(0).(func(*dynamodb.UpdateTimeToLiveInput) *dynamodb.UpdateTimeToLiveOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.UpdateTimeToLiveOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*dynamodb.UpdateTimeToLiveInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateTimeToLiveRequest provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) UpdateTimeToLiveRequest(_a0 *dynamodb.UpdateTimeToLiveInput) (*request.Request, *dynamodb.UpdateTimeToLiveOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*dynamodb.UpdateTimeToLiveInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *dynamodb.UpdateTimeToLiveOutput
	if rf, ok := ret.Get(1).(func(*dynamodb.UpdateTimeToLiveInput) *dynamodb.UpdateTimeToLiveOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*dynamodb.UpdateTimeToLiveOutput)
		}
	}

	return r0, r1
}

// UpdateTimeToLiveWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) UpdateTimeToLiveWithContext(_a0 aws.Context, _a1 *dynamodb.UpdateTimeToLiveInput, _a2 ...request.Option) (*dynamodb.UpdateTimeToLiveOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *dynamodb.UpdateTimeToLiveOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.UpdateTimeToLiveInput, ...request.Option) *dynamodb.UpdateTimeToLiveOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.UpdateTimeToLiveOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *dynamodb.UpdateTimeToLiveInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// WaitUntilTableExists provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) WaitUntilTableExists(_a0 *dynamodb.DescribeTableInput) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*dynamodb.DescribeTableInput) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// WaitUntilTableExistsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) WaitUntilTableExistsWithContext(_a0 aws.Context, _a1 *dynamodb.DescribeTableInput, _a2 ...request.WaiterOption) error {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.DescribeTableInput, ...request.WaiterOption) error); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// WaitUntilTableNotExists provides a mock function with given fields: _a0
func (_m *DynamoDBAPI) WaitUntilTableNotExists(_a0 *dynamodb.DescribeTableInput) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*dynamodb.DescribeTableInput) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// WaitUntilTableNotExistsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *DynamoDBAPI) WaitUntilTableNotExistsWithContext(_a0 aws.Context, _a1 *dynamodb.DescribeTableInput, _a2 ...request.WaiterOption) error {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *dynamodb.DescribeTableInput, ...request.WaiterOption) error); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
