package mocks

import client "code.justin.tv/chat/pubsub-go-pubclient/client"
import context "context"
import dynamodbiface "github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
import io "io"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/upload-service/models"
import os "os"
import s3iface "github.com/aws/aws-sdk-go/service/s3/s3iface"
import snsiface "github.com/aws/aws-sdk-go/service/sns/snsiface"
import uploader "code.justin.tv/web/upload-service/rpc/uploader"

// Backender is an autogenerated mock type for the Backender type
type Backender struct {
	mock.Mock
}

// CreateMetadata provides a mock function with given fields: _a0
func (_m *Backender) CreateMetadata(_a0 models.Upload) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(models.Upload) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CreatePresignedUrl provides a mock function with given fields: uploadId
func (_m *Backender) CreatePresignedUrl(uploadId string) (string, error) {
	ret := _m.Called(uploadId)

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(uploadId)
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(uploadId)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DownloadS3 provides a mock function with given fields: bucket, key
func (_m *Backender) DownloadS3(bucket string, key string) (*os.File, error) {
	ret := _m.Called(bucket, key)

	var r0 *os.File
	if rf, ok := ret.Get(0).(func(string, string) *os.File); ok {
		r0 = rf(bucket, key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*os.File)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(bucket, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DynamoDB provides a mock function with given fields:
func (_m *Backender) DynamoDB() dynamodbiface.DynamoDBAPI {
	ret := _m.Called()

	var r0 dynamodbiface.DynamoDBAPI
	if rf, ok := ret.Get(0).(func() dynamodbiface.DynamoDBAPI); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(dynamodbiface.DynamoDBAPI)
		}
	}

	return r0
}

// EC2InstanceID provides a mock function with given fields:
func (_m *Backender) EC2InstanceID() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// FileSizeS3 provides a mock function with given fields: bucket, key
func (_m *Backender) FileSizeS3(bucket string, key string) (int64, error) {
	ret := _m.Called(bucket, key)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string, string) int64); ok {
		r0 = rf(bucket, key)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(bucket, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMetadata provides a mock function with given fields: uploadID
func (_m *Backender) GetMetadata(uploadID string) (*models.Upload, error) {
	ret := _m.Called(uploadID)

	var r0 *models.Upload
	if rf, ok := ret.Get(0).(func(string) *models.Upload); ok {
		r0 = rf(uploadID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Upload)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(uploadID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MetadataTable provides a mock function with given fields:
func (_m *Backender) MetadataTable() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// NotifyCallbacks provides a mock function with given fields: ctx, upload, status, outputInfos
func (_m *Backender) NotifyCallbacks(ctx context.Context, upload *models.Upload, status uploader.Status, outputInfos []uploader.OutputInfo) error {
	ret := _m.Called(ctx, upload, status, outputInfos)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *models.Upload, uploader.Status, []uploader.OutputInfo) error); ok {
		r0 = rf(ctx, upload, status, outputInfos)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PubClient provides a mock function with given fields:
func (_m *Backender) PubClient() client.PubClient {
	ret := _m.Called()

	var r0 client.PubClient
	if rf, ok := ret.Get(0).(func() client.PubClient); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(client.PubClient)
		}
	}

	return r0
}

// PubsubCallback provides a mock function with given fields: ctx, topic, data, retries
func (_m *Backender) PubsubCallback(ctx context.Context, topic string, data models.SNSCallback, retries int) error {
	ret := _m.Called(ctx, topic, data, retries)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, models.SNSCallback, int) error); ok {
		r0 = rf(ctx, topic, data, retries)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// S3 provides a mock function with given fields:
func (_m *Backender) S3() s3iface.S3API {
	ret := _m.Called()

	var r0 s3iface.S3API
	if rf, ok := ret.Get(0).(func() s3iface.S3API); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(s3iface.S3API)
		}
	}

	return r0
}

// SNS provides a mock function with given fields:
func (_m *Backender) SNS() snsiface.SNSAPI {
	ret := _m.Called()

	var r0 snsiface.SNSAPI
	if rf, ok := ret.Get(0).(func() snsiface.SNSAPI); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(snsiface.SNSAPI)
		}
	}

	return r0
}

// SNSCallback provides a mock function with given fields: arn, data
func (_m *Backender) SNSCallback(arn string, data models.SNSCallback) error {
	ret := _m.Called(arn, data)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, models.SNSCallback) error); ok {
		r0 = rf(arn, data)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetStatus provides a mock function with given fields: ctx, uploadID, status, statusMessage
func (_m *Backender) SetStatus(ctx context.Context, uploadID string, status uploader.Status, statusMessage string) error {
	ret := _m.Called(ctx, uploadID, status, statusMessage)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, uploader.Status, string) error); ok {
		r0 = rf(ctx, uploadID, status, statusMessage)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UploadS3 provides a mock function with given fields: tmpfile, outputPath, contentType, grantFullControl, grantRead
func (_m *Backender) UploadS3(tmpfile io.ReadSeeker, outputPath string, contentType string, grantFullControl string, grantRead string) error {
	ret := _m.Called(tmpfile, outputPath, contentType, grantFullControl, grantRead)

	var r0 error
	if rf, ok := ret.Get(0).(func(io.ReadSeeker, string, string, string, string) error); ok {
		r0 = rf(tmpfile, outputPath, contentType, grantFullControl, grantRead)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
