#!/bin/bash -ex

export SERVICE_NAME="$1"

pip install awsebcli >/dev/null
set +x
export AWS_SECRET_ACCESS_KEY=$AWS_SECRET_KEY
export AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY
export PYTHONUNBUFFERED=1
set -x
export IMAGE=docker-registry.internal.justin.tv/web-upload-service:$GIT_COMMIT
TIMESTAMP=$(TZ=US/Pacific date --iso-8601=seconds)
export LABEL="${TIMESTAMP:0:19}_${GIT_COMMIT:0:10}"
export MESSAGE="$TRIGGERED_BY deployed branch $BRANCH with https://clean-deploy.internal.justin.tv/#/web/upload-service/deploys/$SKADI_ID"

case "${SERVICE_NAME}" in
    prod*)
        export ENVIRONMENT="prod"
        export PUBSUB_URL="wss://pubsub-edge.twitch.tv:443/v1"
        export PUBSUB_TOPIC_PREFIX="upload."
        export AWS_ID=641044725657
        ;;
    *)
        export ENVIRONMENT="staging"
        export PUBSUB_URL="wss://pubsub-edge-darklaunch.twitch.tv:443/v1"
        export PUBSUB_TOPIC_PREFIX="pubsubtest.upload."
        export AWS_ID=465369119046
        ;;
esac

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "$IMAGE",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    },
    {
      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
    },
    {
      "ContainerDirectory": "/tmp",
      "HostDirectory": "/dockertmp"
    }
  ],
  "Logging": "/var/log/"
}
EOF

echo 1 | eb init ${SERVICE_NAME} --region us-west-2 --platform "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2

export PREVIOUS=`eb status | sed -e '/^  Deployed/!d' -e 's/^  Deployed Version: //'`

mkdir -p build
zip -r build/artifact.zip .

rm -f server_failed worker_failed

# Note: The output of the second command will be buffered while the first command is running and shown when the first
# command completes. The timestamps in Jenkins will be wrong
cat \
  <(eb deploy ${SERVICE_NAME}-server-env --label "$LABEL" --message "$MESSAGE" --timeout 45 || touch server_failed ) \
  <(eb deploy ${SERVICE_NAME}-worker-env --label "$LABEL" --message "$MESSAGE" --timeout 45 || touch worker_failed )

if [[ -e server_failed ]] && [[ -e worker_failed ]] ; then
  echo "Both deploys failed"
  exit 1
elif [[ -e server_failed ]] || [[ -e worker_failed ]] ; then
  scripts/rollback.sh;
fi

# eb deploy blocks until the deploy passes healthchecks, so we can run this immediately after
./bin/test || scripts/rollback.sh
