package files

import (
	"io/ioutil"
	"os"
)

type FileOperations interface {
	Remove(name string) error
	RemoveAll(path string) error
	TempDir(dir, prefix string) (name string, err error)
	TempFile(dir, prefix string) (f *os.File, err error)
}

type RealFileOperator struct{}

func (rfo *RealFileOperator) Remove(name string) error {
	return os.Remove(name)
}

func (rfo *RealFileOperator) RemoveAll(path string) error {
	return os.RemoveAll(path)
}

func (rfo *RealFileOperator) TempDir(dir, prefix string) (string, error) {
	return ioutil.TempDir(dir, prefix)
}

func (rfo *RealFileOperator) TempFile(dir, prefix string) (f *os.File, err error) {
	return ioutil.TempFile(dir, prefix)
}
