package mocks

import mock "github.com/stretchr/testify/mock"
import os "os"

// FileOperations is an autogenerated mock type for the FileOperations type
type FileOperations struct {
	mock.Mock
}

// Remove provides a mock function with given fields: name
func (_m *FileOperations) Remove(name string) error {
	ret := _m.Called(name)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(name)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveAll provides a mock function with given fields: path
func (_m *FileOperations) RemoveAll(path string) error {
	ret := _m.Called(path)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(path)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// TempDir provides a mock function with given fields: dir, prefix
func (_m *FileOperations) TempDir(dir string, prefix string) (string, error) {
	ret := _m.Called(dir, prefix)

	var r0 string
	if rf, ok := ret.Get(0).(func(string, string) string); ok {
		r0 = rf(dir, prefix)
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(dir, prefix)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// TempFile provides a mock function with given fields: dir, prefix
func (_m *FileOperations) TempFile(dir string, prefix string) (*os.File, error) {
	ret := _m.Called(dir, prefix)

	var r0 *os.File
	if rf, ok := ret.Get(0).(func(string, string) *os.File); ok {
		r0 = rf(dir, prefix)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*os.File)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(dir, prefix)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
