job {
    name 'web-upload-service'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'web/upload-service', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }

    steps {
        shell 'echo "building web-upload-service, env:"; env'
        shell 'make push'
        reportCodeCoverage('web/upload-service', '.', 'coverage.txt')
        saveDeployArtifact 'web/upload-service-ebextensions', 'deploy/'
        conditionalSteps {
            condition {
                stringsMatch('\$GIT_BRANCH', 'origin/master', false)
            }
            runner('DontRun')
            steps {
                shell("scripts/semver.sh")
            }
        }
    }
    publishers {
        flexiblePublish {
            conditionalAction {
                condition {
                    stringsMatch('\$GIT_BRANCH', 'origin/master', false)
                }
                runner('DontRun')
                publishers {
                    downstreamParameterized{
                        trigger('web-upload-service-staging-deploy') {
                            condition('SUCCESS')
                            parameters {
                                predefinedProp('ACCOUNT_ID', 'twitch-web-dev')
                                predefinedProp('ENVIRONMENT', 'staging')
                                predefinedProp('BRANCH', 'origin/master')
                                predefinedProp('REPO', 'upload-service')
                                predefinedProp('OWNER', 'web')
                                predefinedProp('TRIGGERED_BY', 'triggered_by')
                                predefinedProp('GIT_COMMIT', '\$GIT_COMMIT')
                            }
                        }
                    }
                }
            }
        }
    }
}




freeStyleJob('web-upload-service-prod-deploy') {
    using 'TEMPLATE-deploy-aws'
    concurrentBuild false

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-web-aws-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-web-aws-tcs-secret-key'
        }
    }

    parameters {
    stringParam('ACCOUNT_ID', 'account id', 'account id')
    stringParam('REPO', 'repo', 'repo')
    stringParam('OWNER', 'owner', 'owner')
    stringParam('ENVIRONMENT', 'environment' , 'environment')
    stringParam('NODES_DC', 'nodes_dc', 'nodes_dc')
    stringParam('TRIGGERED_BY', 'triggered_by', 'triggered_by')
    stringParam('BRANCH', 'branch', 'branch')
    stringParam('SKADI_ID', 'skadi_id', 'skadi_id')
    }

    steps {
    shell 'echo "beginning deploy to prod, env:"; env'
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/upload-service-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell 'scripts/jenkins_deploy.sh prod-web-upload-service'
    }
}




freeStyleJob('web-upload-service-staging-deploy') {
    using 'TEMPLATE-deploy-aws'
    concurrentBuild false

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-web-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-web-dev-tcs-secret-key'
        }
    }

    parameters {
	stringParam('ACCOUNT_ID', 'account id', 'account id')
	stringParam('REPO', 'repo', 'repo')
	stringParam('OWNER', 'owner', 'owner')
	stringParam('ENVIRONMENT', 'environment' , 'environment')
	stringParam('NODES_DC', 'nodes_dc', 'nodes_dc')
	stringParam('TRIGGERED_BY', 'triggered_by', 'triggered_by')
	stringParam('BRANCH', 'branch', 'branch')
    stringParam('SKADI_ID', 'skadi_id', 'skadi_id')
    }

    steps {
	shell 'echo "beginning deploy to staging, env:"; env'
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/upload-service-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell 'scripts/jenkins_deploy.sh staging-web-upload-service'
    }

    publishers {
        flexiblePublish {
            conditionalAction {
                condition {
                    stringsMatch('\$BRANCH', 'origin/master', false)
                }
                runner('DontRun')
                publishers {
                    downstreamParameterized{
                        trigger('web-upload-service-prod-deploy') {
                            condition('SUCCESS')
                            parameters {
                                currentBuild()
                                predefinedProp('ACCOUNT_ID', 'twitch-web-aws')
                                predefinedProp('ENVIRONMENT', 'prod')
                            }
                        }
                    }
                }
            }
        }
    }
}

freeStyleJob('web-upload-service-marty-deploy') {
    using 'TEMPLATE-deploy-aws'
    concurrentBuild false

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-web-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-web-dev-tcs-secret-key'
        }
    }

    parameters {
	stringParam('ACCOUNT_ID', 'account id', 'account id')
	stringParam('REPO', 'repo', 'repo')
	stringParam('OWNER', 'owner', 'owner')
	stringParam('ENVIRONMENT', 'environment' , 'environment')
	stringParam('NODES_DC', 'nodes_dc', 'nodes_dc')
	stringParam('TRIGGERED_BY', 'triggered_by', 'triggered_by')
	stringParam('BRANCH', 'branch', 'branch')
	stringParam('SKADI_ID', 'skadi_id', 'skadi_id')
    }

    steps {
	shell 'echo "beginning deploy to marty, env:"; env'
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/upload-service-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell 'scripts/jenkins_deploy.sh marty-web-upload-service'
    }
}

freeStyleJob('web-upload-service-jeff-deploy') {
    using 'TEMPLATE-deploy-aws'
    concurrentBuild false

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-web-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-web-dev-tcs-secret-key'
        }
    }

    parameters {
	stringParam('ACCOUNT_ID', 'account id', 'account id')
	stringParam('REPO', 'repo', 'repo')
	stringParam('OWNER', 'owner', 'owner')
	stringParam('ENVIRONMENT', 'environment' , 'environment')
	stringParam('NODES_DC', 'nodes_dc', 'nodes_dc')
	stringParam('TRIGGERED_BY', 'triggered_by', 'triggered_by')
	stringParam('BRANCH', 'branch', 'branch')
	stringParam('SKADI_ID', 'skadi_id', 'skadi_id')
    }

    steps {
	shell 'echo "beginning deploy to jeff, env:"; env'
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/upload-service-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell 'scripts/jenkins_deploy.sh jeff-web-upload-service'
    }
}

freeStyleJob('web-upload-service-kevin-deploy') {
    using 'TEMPLATE-deploy-aws'
    concurrentBuild false

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-web-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-web-dev-tcs-secret-key'
        }
    }

    parameters {
    stringParam('ACCOUNT_ID', 'account id', 'account id')
    stringParam('REPO', 'repo', 'repo')
    stringParam('OWNER', 'owner', 'owner')
    stringParam('ENVIRONMENT', 'environment' , 'environment')
    stringParam('NODES_DC', 'nodes_dc', 'nodes_dc')
    stringParam('TRIGGERED_BY', 'triggered_by', 'triggered_by')
    stringParam('BRANCH', 'branch', 'branch')
    stringParam('SKADI_ID', 'skadi_id', 'skadi_id')
    }

    steps {
    shell 'echo "beginning deploy to kevin, env:"; env'
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/upload-service-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell 'scripts/jenkins_deploy.sh kevin-web-upload-service'
    }
}

