package middleware

import (
	"bytes"
	"encoding/json"
	"io/ioutil"
	"net/http"
	"time"

	log "github.com/sirupsen/logrus"
)

func LoggingMiddleware() func(http.Handler) http.Handler {
	return func(h http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			statusWriter := &statusLenResponseWriter{w, 0, 200}
			startTime := time.Now()

			b, err := ioutil.ReadAll(r.Body)
			r.Body = ioutil.NopCloser(bytes.NewBuffer(b))

			h.ServeHTTP(statusWriter, r)

			duration := time.Since(startTime)
			responseCode := statusWriter.status
			responseLen := statusWriter.responseLen
			endpoint := r.URL.Path

			isJSON := false
			if err == nil {
				var js map[string]interface{}
				isJSON = json.Unmarshal(b, &js) == nil
			}

			logEntry := log.WithFields(log.Fields{
				"endpoint":     endpoint,
				"duration":     duration,
				"responseCode": responseCode,
				"responseLen":  responseLen,
				"headers":      r.Header,
			})
			if isJSON {
				logEntry = logEntry.WithField("requestJSON", string(b))
			}

			logEntry.Info("Request completed")
		})
	}
}
