package middleware

import (
	"net/http"
)

type statusLenResponseWriter struct {
	http.ResponseWriter
	responseLen int
	status      int
}

func (sw *statusLenResponseWriter) Write(b []byte) (int, error) {
	sw.responseLen += len(b)
	return sw.ResponseWriter.Write(b)
}

func (sw *statusLenResponseWriter) WriteHeader(c int) {
	sw.ResponseWriter.WriteHeader(c)
	sw.status = c
}
