package middleware

import (
	"context"
	"net/http"
	"time"
)

type startTime int

const startTimeKey = startTime(0)

func StartTime(ctx context.Context) (t time.Time, ok bool) {
	t, ok = ctx.Value(startTimeKey).(time.Time)
	return t, ok
}

func withStartTime(parent context.Context, startTime time.Time) context.Context {
	return context.WithValue(parent, startTimeKey, startTime)
}

func StartTimeMiddleware(h http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		r = r.WithContext(withStartTime(r.Context(), time.Now()))
		h.ServeHTTP(w, r)
	})
}
