package models

import (
	"testing"

	"encoding/json"

	"code.justin.tv/web/upload-service/rpc/uploader"
	"github.com/stretchr/testify/suite"
)

type CallbackTestSuite struct {
	suite.Suite
}

func (suite *CallbackTestSuite) TestOutputInfoCompatibility() {
	rpcStruct := uploader.OutputInfo{
		Path:         "path",
		Name:         "name",
		NameTemplate: "nameTemplate",
		Format:       "format",
		Width:        111,
		Height:       222,
		Dimensions:   "111x222",
		FileSize:     333,
	}
	jsonBytes, err := json.Marshal(rpcStruct)
	suite.Require().NoError(err)

	deprecatedStruct := &OutputInfo{}
	err = json.Unmarshal(jsonBytes, deprecatedStruct)
	suite.Require().NoError(err)

	suite.Require().Equal(deprecatedStruct.Path, rpcStruct.Path)
	suite.Require().Equal(deprecatedStruct.Name, rpcStruct.Name)
	suite.Require().Equal(deprecatedStruct.NameTemplate, rpcStruct.NameTemplate)
	suite.Require().Equal(deprecatedStruct.Format, rpcStruct.Format)
	suite.Require().Equal(uint32(deprecatedStruct.Width), rpcStruct.Width)
	suite.Require().Equal(uint32(deprecatedStruct.Height), rpcStruct.Height)
	suite.Require().Equal(deprecatedStruct.Dimensions, rpcStruct.Dimensions)
	suite.Require().Equal(deprecatedStruct.FileSize, rpcStruct.FileSize)
}

func TestCallback(t *testing.T) {
	suite.Run(t, new(CallbackTestSuite))
}
