package server

import (
	"context"
	"testing"

	"code.justin.tv/web/upload-service/rpc/server/mocks"
	"github.com/stretchr/testify/suite"
)

type UploaderTestSuite struct {
	suite.Suite

	uploader mocks.Uploader
}

func (suite *UploaderTestSuite) SetupTest() {
	suite.uploader = mocks.Uploader{}
}

func (suite *UploaderTestSuite) TestSuccessfulCreateRequest() {
	req := mocks.MockValidUploadRequest()

	suite.uploader.MockSuccessfulCreate()

	resp, err := suite.uploader.Create(context.Background(), &req)

	suite.Require().NoError(err)
	suite.Require().NotNil(resp)
}

func (suite *UploaderTestSuite) TestUnsuccessfulCreateRequest() {
	req := mocks.MockInvalidUploadRequest()

	suite.uploader.MockUnsuccessfulCreate()

	resp, err := suite.uploader.Create(context.Background(), &req)

	suite.Require().Error(err)
	suite.Require().Nil(resp)
}

func (suite *UploaderTestSuite) TestUnsuccessfulCreateRequestWithInvalidBucket() {
	req := mocks.MockInvalidUploadRequest()

	suite.uploader.MockUnsuccessfulInvalidBucketCreate()

	resp, err := suite.uploader.Create(context.Background(), &req)

	suite.Require().Error(err)
	suite.Require().Nil(resp)
}

func (suite *UploaderTestSuite) TestSuccessfulSetStatusRequest() {
	req := mocks.MockValidSetStatusRequest()

	suite.uploader.MockSuccessSetStatus()

	resp, err := suite.uploader.SetStatus(context.Background(), &req)

	suite.Require().NoError(err)
	suite.Require().NotNil(resp)
}

func (suite *UploaderTestSuite) TestUnsuccessfulSetStatusRequest() {
	req := mocks.MockInvalidSetStatusRequest()

	suite.uploader.MockFailureSetStatus()

	resp, err := suite.uploader.SetStatus(context.Background(), &req)

	suite.Require().Error(err)
	suite.Require().Nil(resp)
}

func (suite *UploaderTestSuite) TestSuccessfulStatusRequest() {
	req := mocks.MockValidStatusRequest()

	suite.uploader.MockSuccessStatus()

	resp, err := suite.uploader.Status(context.Background(), &req)

	suite.Require().NoError(err)
	suite.Require().NotNil(resp)
}

func (suite *UploaderTestSuite) TestUnsuccessfulStatusRequest() {
	req := mocks.MockInvalidStatusRequest()

	suite.uploader.MockFailureStatus()

	_, err := suite.uploader.Status(context.Background(), &req)

	suite.Require().Error(err)
}

func TestUploader(t *testing.T) {
	suite.Run(t, new(UploaderTestSuite))
}
