#!/bin/bash

#
# How to use:
# Run the script to start the docker container in interactive mode.
# From inside the container, run the provided functions to run tests and setup environment variables
# The functions that require the moto server will start it automatically if it is not already running
# The end to end test and testing individual packages should be run with explicit commands
#

MAP=""
join_by() {
	local IFS="$1"
	shift
	echo "$*"
}

put() {
	local key="$1"
	shift

	MAP="${key}=$(join_by , $@) ${MAP}"
}

get() {
	for keyValuePair in $MAP;
	do
		case "$keyValuePair" in
			$1=*)
				values=(`echo "$keyValuePair" | sed 's/.*=//' | sed 's/,/ /g'`)
		esac
	done
}

moto() {
	ps | grep moto_server > /dev/null || (echo "moto_server started"; moto_server 2> /dev/null &)
}

setup() {
	put prod    prod-web-upload-service
	put staging staging-web-upload-service
	put marty   marty-web-upload-service
	put jeff    jeff-web-upload-service
	put kevin   kevin-web-upload-service
	get $1
	export SERVICE_NAME="${values[0]}"
	case "${SERVICE_NAME}" in
		prod*)
			export ENVIRONMENT="prod"
			export PUBSUB_URL="wss://pubsub-edge.twitch.tv:443/v1"
			export PUBSUB_TOPIC_PREFIX="upload."
			export AWS_ID=641044725657
			;;
		*)
			export ENVIRONMENT="staging"
			export PUBSUB_URL="wss://pubsub-edge-darklaunch.twitch.tv:443/v1"
			export PUBSUB_TOPIC_PREFIX="pubsubtest.upload."
			export AWS_ID=465369119046
			;;
	esac
}
seesetup() {
	echo SERVICE_NAME=$SERVICE_NAME
	echo PUBSUB_URL=$PUBSUB_URL
	echo PUBSUB_TOPIC_PREFIX=$PUBSUB_TOPIC_PREFIX
	echo AWS_ID=$AWS_ID
}
unsetup() {
	export SERVICE_NAME=""
	export PUBSUB_URL=""
	export PUBSUB_TOPIC_PREFIX=""
	export AWS_ID=""
	echo SERVICE_NAME=$SERVICE_NAME
	echo PUBSUB_URL=$PUBSUB_URL
	echo PUBSUB_TOPIC_PREFIX=$PUBSUB_TOPIC_PREFIX
	echo AWS_ID=$AWS_ID
}
build() {
	make build-in-container && echo "make build-in-container has completed successfully"
}
testall() {
	moto
	go test ./... && echo "All tests passed successfully"
}
all() {
	moto
	make build-in-container && go test ./... && echo "All tests passed successfully"
}
makebin() {
	go build -o bin/upload-service cmd/upload-service/main.go && echo "bin/upload-service has been built successfully"
}

e2e() {
	go build -o deploy/bin/test cmd/e2e_test/end_to_end.go && echo "deploy/bin/test has been built successfully"
	bash -c "cd deploy && bin/test"
}

which docker &> /dev/null && docker run -it -u $(id -u) --group-add $(id -g) \
	-v $PWD:/go/src/code.justin.tv/web/upload-service --rm upload-service:build \
	/bin/bash --rcfile /go/src/code.justin.tv/web/upload-service/scripts/dockerscript.sh -i
