resource "aws_route53_record" "jtv" {
  provider = "aws.dns"
  zone_id = "ZRG00SM48517Z"
  name = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}.${var.env}.us-west2.justin.tv"
  type = "CNAME"
  ttl = 300
  records = ["${module.eb-env.server_cname}"]
}

resource "aws_route53_record" "ttv" {
  provider = "aws.dns"
  zone_id = "Z127RUWUPOFGHX"
  name = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}.${var.env}.us-west2.twitch.tv"
  type = "CNAME"
  ttl = 300
  records = ["${module.eb-env.server_cname}"]
}
