module "dynamo_table" {
  source = "../metadata-tables"
  read_capacity = "${var.dynamo_capacity["read"]}"
  write_capacity = "${var.dynamo_capacity["write"]}"
  index_read_capacity = "${var.dynamo_capacity["gsi_read"]}"
  index_write_capacity = "${var.dynamo_capacity["gsi_write"]}"
  env = "${var.env}"
  common_name = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
}
