module "eb-env" {
  source = "../beanstalk_env"
  aws_profile = "${var.aws_profile}"
  eb_application_name = "${module.eb-app.beanstalk_application_name}"
  vpc_id = "${data.terraform_remote_state.twitch_web_dev.vpc_id}"
  ec2_subnet_ids = "${data.terraform_remote_state.twitch_web_dev.service_subnets}"
  elb_subnet_ids = "${data.terraform_remote_state.twitch_web_dev.service_subnets}"
  elb_loadbalancer_security_groups = "${data.terraform_remote_state.twitch_web_dev.twitch_subnets_sg}"
  auto_scaling_lc_security_groups = "${data.terraform_remote_state.twitch_web_dev.twitch_subnets_sg}"
  solution_stack_name = "${var.solution_stack_name}"
  instance_type = "${var.instance_type}"
  asg_min_size = "${var.asg_min_size}"
  asg_max_size = "${var.asg_max_size}"
  owner = "${var.owner}"
  service = "${var.service}"
  env = "${var.env}"
  common_name = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  worker_queue_url = "${module.s3_ingest_bucket.worker_queue_url}"
  worker_queue_arn = "${module.s3_ingest_bucket.worker_queue_arn}"
  s3_bucket = "${module.s3_ingest_bucket.s3_bucket}"
  s3_bucket_arn = "${module.s3_ingest_bucket.s3_bucket_arn}"
  sqs_queue_arn = "${module.s3_ingest_bucket.worker_queue_arn}"
  sqs_queue_url = "${module.s3_ingest_bucket.worker_queue_url}"
  metadata_table = "${module.dynamo_table.metadata_table}"
  pubsub_endpoint = "${var.pubsub_endpoint}"
  solution_stack_name = "${var.solution_stack_name}"
  topic_prefix = "${var.topic_prefix}"
  log_level = "${var.log_level}"
}
