// Worker and Server have to be separate log streams because cloudformation doesn't have all the same variables
// easily accessible. See deploy/.ebextensions/04-cwlogs-docker.config for the pieces that actual send log files to
// these cloudwatch logs log groups.

resource "aws_cloudwatch_log_group" "service_log_server" {
  name = "/aws/elasticbeanstalk/${coalesce(var.common_name, null_resource.vars.triggers.cn)}-server-env/var/log/upload-service.log"
  retention_in_days = 7

  tags {
    Environment = "${var.env}"
    Application = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-server-env"
    Service = "${var.service}"
    Owner = "${var.owner}"
  }
}

resource "aws_cloudwatch_log_group" "service_log_worker" {
  name = "/aws/elasticbeanstalk/${coalesce(var.common_name, null_resource.vars.triggers.cn)}-worker-env/var/log/upload-service.log"
  retention_in_days = 7

  tags {
    Environment = "${var.env}"
    Application = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-worker-env"
    Service = "${var.service}"
    Owner = "${var.owner}"
  }
}

resource "aws_cloudwatch_log_group" "service_output_server" {
  name = "/aws/elasticbeanstalk/${coalesce(var.common_name, null_resource.vars.triggers.cn)}-server-env/var/log/docker-stdouterr.log"
  retention_in_days = 7

  tags {
    Environment = "${var.env}"
    Application = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-server-env"
    Service = "${var.service}"
    Owner = "${var.owner}"
  }
}

resource "aws_cloudwatch_log_group" "service_output_worker" {
  name = "/aws/elasticbeanstalk/${coalesce(var.common_name, null_resource.vars.triggers.cn)}-worker-env/var/log/docker-stdouterr.log"
  retention_in_days = 7

  tags {
    Environment = "${var.env}"
    Application = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-worker-env"
    Service = "${var.service}"
    Owner = "${var.owner}"
  }
}

resource "aws_cloudwatch_log_metric_filter" "error_count_server" {
  name           = "ErrorCount-${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  pattern        = "{ $.level = \"error\" }"
  log_group_name = "${aws_cloudwatch_log_group.service_log_server.name}"

  metric_transformation {
    name      = "ErrorCount"
    namespace = "Upload/${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
    value     = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "error_count_worker" {
  name           = "ErrorCount-${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  pattern        = "{ $.level = \"error\" }"
  log_group_name = "${aws_cloudwatch_log_group.service_log_worker.name}"

  metric_transformation {
    name      = "ErrorCount"
    namespace = "Upload/${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
    value     = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "start_count_worker" {
  name           = "StartCount-${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  pattern        = "application listening on"
  log_group_name = "${aws_cloudwatch_log_group.service_output_worker.name}"

  metric_transformation {
    name      = "WorkerStartCount"
    namespace = "Upload/${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
    value     = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "time_limit_exceeded_count_worker" {
  name           = "TimeLimitExceededCount-${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  pattern        = "time limit exceeded"
  log_group_name = "${aws_cloudwatch_log_group.service_output_worker.name}"

  metric_transformation {
    name      = "WorkerTimeLimitExceededCount"
    namespace = "Upload/${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
    value     = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "extent_count_worker" {
  name           = "ExtentCount-${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  pattern        = "unable to extent pixel cache"
  log_group_name = "${aws_cloudwatch_log_group.service_output_worker.name}"

  metric_transformation {
    name      = "UnableToExtentCount"
    namespace = "Upload/${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
    value     = "1"
  }
}