resource "aws_s3_bucket" "output" {
  bucket = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-output"
  acl    = "public-read"
  tags {
    Owner = "edge-infra@twitch.tv"
  }
}
data "aws_iam_policy_document" "s3_access" {
  statement {
    effect = "Allow"
    principals {
      type = "AWS"
      identifiers = ["${module.eb-env.iam_role_arn}"]
    }
    actions = ["s3:PutObject", "s3:PutObjectAcl"]
    resources = ["${aws_s3_bucket.output.arn}/*"]
  },
  statement {
    effect = "Allow"
    principals {
      type = "AWS"
      identifiers = ["*"]
    }
    actions = ["s3:GetObject"]
    resources = ["${aws_s3_bucket.output.arn}/*"]
  }
}
 
resource "aws_s3_bucket_policy" "output" {
  bucket = "${aws_s3_bucket.output.id}"
  policy = "${data.aws_iam_policy_document.s3_access.json}"
}
