variable "aws_profile" {
  description = "AWS profile to use"
}

variable "app_name" {
  description = "EB app name"
  default = ""
}

variable "solution_stack_name" {
  description = "See EB documentation for valid values"
  default = "64bit Amazon Linux 2017.09 v2.8.0 running Docker 17.06.2-ce"
}

variable "instance_type" {
  description = "how much money do you want to spend?"
  type = "map"
  default = {
    worker = "c5.large"
    server = "c5.large"
  }
}

variable "asg_min_size" {
  description = "how much money do you want to spend?"
  type = "map"
  default = {
    worker = 1
    server = 1
  }
}

variable "asg_max_size" {
  description = "how much money do you want to spend?"
  type = "map"
  default = {
    worker = 1
    server = 1
  }
}

variable "owner" {
  description = "who do you want to page"
  default = "edge-infra@twitch.tv"
}

variable "service" { 
  description = "repo name is probably fine"
  default = "web/upload-service"
}

variable "env" {
  description = "environment"
}

variable "sandstorm_role_arn" {
  description = "sandstorm role arn"
}

variable "common_name" {
  description = "common name?"
  default = ""
}

variable "pubsub_endpoint" {
  description = "pubsub broker endpoint to publish messages to"
}

variable "topic_prefix" {
  description = "prefix of the pubsub topic to publish under"
}

variable "log_level" {
  description = "log level (debug, info, warn, error, fatal, panic)"
  default = "info"
}

variable "pagerduty_endpoint" {
  description = "Pagerduty webhook endpoints for urgent and low-priority alerts."
  type = "map"
  default = {
    urgent = ""
    daytime = ""
    low = ""
  }
}

variable "dynamo_capacity" {
  description = "Capacity limits for dynamo metadata table"
  type = "map"
  default = {
    write = "25"
    read = "25"
    gsi_write = "10"
    gsi_read = "10"
  }
}

resource "null_resource" "vars" {
  triggers {
    cn = "${replace("${var.env}-${var.service}", "/", "-")}"
  }
}
