resource "aws_s3_bucket" "ingest" {
  bucket = "${var.common_name}-ingest"
  acl    = "private"

  acceleration_status = "Enabled"

  cors_rule {
    allowed_methods = ["PUT"]
    allowed_origins = ["*"]
    allowed_headers = ["Content-Length", "Content-Type", "Content-MD5", "Date", "Expect"]
  }
}

resource "aws_sqs_queue" "worker-dead-letter" {
  name = "${var.common_name}-dead-letter"
  message_retention_seconds = 60
}

resource "aws_sqs_queue" "worker" {
  name = "${var.common_name}-worker"
  message_retention_seconds = 1209600
  visibility_timeout_seconds = 30
  redrive_policy = "{\"deadLetterTargetArn\":\"${aws_sqs_queue.worker-dead-letter.arn}\",\"maxReceiveCount\":${var.worker_max_attempts}}"
}

resource "aws_s3_bucket_notification" "ingest_sqs_link" {
  bucket = "${aws_s3_bucket.ingest.id}"

  queue {
    queue_arn     = "${aws_sqs_queue.worker.arn}"
    events        = ["s3:ObjectCreated:*"]
  }
}
