variable "env" {
  description = "The AWS environment. Must begin with one of the following:  dev (development),  stage (staging), or  prod (production)."
  default     = "dev"
}

variable "worker_max_attempts" {
  description = "Number of times workers will attempt to process an upload before sending it to the dead letter queue."
  default = 5
}

# dynamic variables
variable "common_name" {
  description = "Name used as a base for created resources. Must only contain upper/lower case letters, digits, and dash. Default if not specified: ${var.env}-${var.service}"
  default     = ""
}

variable "service" {
  description = "All lower­case, in  team/service/[role] format. This tag should indicate the server’s function and what is running on it;  role is optional but highly recommended. #REQUIRED"
}
