resource "aws_dynamodb_table" "metadata" {
  name = "${var.common_name}-metadata"
  read_capacity = "${var.read_capacity}"
  write_capacity = "${var.write_capacity}"

  hash_key = "upload_id"

  attribute {
    name = "upload_id"
    type = "S"
  }

  attribute {
    name = "status"
    type = "S"
  }

  global_secondary_index {
    name               = "status_index"
    hash_key           = "status"
    write_capacity     = "${var.index_write_capacity}"
    read_capacity      = "${var.index_read_capacity}"
    projection_type    = "ALL"
  }
}
