module "production" {
  source = "../modules/environment"
  env = "prod"
  aws_profile = "twitch-web-aws"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/edge-infra-production-upload-service"
  pubsub_endpoint = "http://pubsub-broker.internal.twitch.tv"
  topic_prefix = "upload."
  asg_min_size = {
    "server" = 3
    "worker" = 5
  }
  asg_max_size = {
    "server" = 3
    "worker" = 5
  }
  pagerduty_endpoint = {
    urgent = "https://events.pagerduty.com/integration/f55ed494bf5647f78b03f832f5dc4806/enqueue"
    daytime = "https://events.pagerduty.com/integration/93638250dea6425bae82eeb2d87299b2/enqueue"
    low = "https://events.pagerduty.com/integration/6cb5b425609042628249451b09f5baff/enqueue"
  }
  dynamo_capacity = {
    read = 200
    write = 1000
    gsi_read = 100
    gsi_write = 100
  }
  instance_type = {
    worker = "c5.2xlarge"
    server = "c5.large"
  }
}
