module "staging" {
  source = "../modules/environment"
  env = "staging"
  aws_profile = "twitch-web-dev"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/edge-infra-staging-upload-service"
  pubsub_endpoint = "http://pubsub-broker-darklaunch.internal.twitch.tv"
  topic_prefix = "pubsubtest.upload."
  log_level = "debug"

  pagerduty_endpoint = {
    urgent = ""
    daytime = "https://events.pagerduty.com/integration/93638250dea6425bae82eeb2d87299b2/enqueue"
    low = "https://events.pagerduty.com/integration/6cb5b425609042628249451b09f5baff/enqueue"
  }
}
