package cwrapper

import (
	"code.justin.tv/web/upload-service/transformations"
	"gopkg.in/gographics/imagick.v2/imagick"
)

func AspectRatio(ar *transformations.AspectRatio, mw *imagick.MagickWand) error {
	curWidth := mw.GetImageWidth()
	curHeight := mw.GetImageHeight()
	curRatio := float64(curWidth) / float64(curHeight)

	var err error
	if ar.Ratio > curRatio {
		newHeight := uint(curRatio / ar.Ratio * float64(curHeight))
		diff := curHeight - newHeight
		err = mw.CropImage(curWidth, newHeight, 0, int(diff/2))
	} else {
		newWidth := uint(ar.Ratio / curRatio * float64(curWidth))
		diff := curWidth - newWidth
		err = mw.CropImage(newWidth, curHeight, int(diff/2), 0)
	}

	return err
}
