package cwrapper

import (
	"testing"

	"gopkg.in/gographics/imagick.v2/imagick"

	"fmt"

	"code.justin.tv/web/upload-service/transformations"
	"github.com/stretchr/testify/suite"
)

type AspectRatioTestSuite struct {
	suite.Suite
	mw *imagick.MagickWand
}

func (suite *AspectRatioTestSuite) SetupSuite() {
	imagick.Initialize()
}

func (suite *AspectRatioTestSuite) SetupTest() {
	suite.mw = imagick.NewMagickWand()

	err := suite.mw.ReadImage("../../test_images/me.jpg")
	if err != nil {
		fmt.Println("error reading", err.Error(), err)
	}
}

func (suite *AspectRatioTestSuite) TearDownTest() {
	suite.mw.Destroy()
}

func (suite *AspectRatioTestSuite) TearDownSuite() {
	imagick.Terminate()
}

func (suite *AspectRatioTestSuite) test(ratio float64) {
	c := transformations.AspectRatio{ratio}
	err := ApplyTransformation(&c, suite.mw)
	suite.Require().NoError(err)

	suite.Require().InEpsilon(float64(suite.mw.GetImageWidth())/float64(suite.mw.GetImageHeight()), ratio, 0.01)
}

func (suite *AspectRatioTestSuite) TestAspectRatioWide() {
	suite.test(2.5)
}

func (suite *AspectRatioTestSuite) TestAspectRatioTall() {
	suite.test(0.5)
}

func TestAspectRatio(t *testing.T) {
	suite.Run(t, new(AspectRatioTestSuite))
}
