package cwrapper

import (
	"testing"

	"gopkg.in/gographics/imagick.v2/imagick"

	"fmt"

	"code.justin.tv/web/upload-service/transformations"
	"github.com/stretchr/testify/suite"
)

type CropTestSuite struct {
	suite.Suite
	mw *imagick.MagickWand
}

func (suite *CropTestSuite) SetupSuite() {
	imagick.Initialize()
}

func (suite *CropTestSuite) SetupTest() {
	suite.mw = imagick.NewMagickWand()

	err := suite.mw.ReadImage("../../test_images/me.jpg")
	if err != nil {
		fmt.Println("error reading", err.Error(), err)
	}
}

func (suite *CropTestSuite) TearDownTest() {
	suite.mw.Destroy()
}

func (suite *CropTestSuite) TearDownSuite() {
	imagick.Terminate()
}

// Test the Top and Left arguments to Crop by placing the initial point near the edge of the image so the final
// width and height are smaller than the requested width and height.
func (suite *CropTestSuite) TestCropTopLeft() {
	width := suite.mw.GetImageWidth()
	height := suite.mw.GetImageHeight()

	c := transformations.Crop{Top: int(height - 10), Left: int(width - 20), Width: 30, Height: 50}
	err := ApplyTransformation(&c, suite.mw)
	suite.Require().NoError(err)

	suite.Require().Equal(suite.mw.GetImageWidth(), uint(20))
	suite.Require().Equal(suite.mw.GetImageHeight(), uint(10))
}

func (suite *CropTestSuite) TestCropWidthHeight() {
	c := transformations.Crop{Width: 30, Height: 50}
	err := ApplyTransformation(&c, suite.mw)
	suite.Require().NoError(err)

	suite.Require().Equal(suite.mw.GetImageWidth(), uint(30))
	suite.Require().Equal(suite.mw.GetImageHeight(), uint(50))
}

func TestCrop(t *testing.T) {
	suite.Run(t, new(CropTestSuite))
}
