package cwrapper

import (
	"code.justin.tv/web/upload-service/transformations"
	"gopkg.in/gographics/imagick.v2/imagick"
)

func MaxWidth(maxWidth *transformations.MaxWidth, mw *imagick.MagickWand) error {
	curWidth := mw.GetImageWidth()
	if curWidth <= maxWidth.MaxWidth {
		return nil
	}

	diff := curWidth - maxWidth.MaxWidth

	curHeight := mw.GetImageHeight()
	err := mw.CropImage(maxWidth.MaxWidth, curHeight, int(diff/2), 0)
	return err
}

func MaxHeight(maxHeight *transformations.MaxHeight, mw *imagick.MagickWand) error {
	curHeight := mw.GetImageHeight()
	if curHeight <= maxHeight.MaxHeight {
		return nil
	}

	diff := curHeight - maxHeight.MaxHeight

	curWidth := mw.GetImageWidth()
	err := mw.CropImage(curWidth, maxHeight.MaxHeight, 0, int(diff/2))
	return err
}
