package cwrapper

import (
	"testing"

	"gopkg.in/gographics/imagick.v2/imagick"

	"fmt"

	"code.justin.tv/web/upload-service/transformations"
	"github.com/stretchr/testify/suite"
)

type MaxDimensionTestSuite struct {
	suite.Suite
	mw *imagick.MagickWand
}

func (suite *MaxDimensionTestSuite) SetupSuite() {
	imagick.Initialize()
}

func (suite *MaxDimensionTestSuite) SetupTest() {
	suite.mw = imagick.NewMagickWand()

	err := suite.mw.ReadImage("../../test_images/me.jpg")
	if err != nil {
		fmt.Println("error reading", err.Error(), err)
	}
}

func (suite *MaxDimensionTestSuite) TearDownTest() {
	suite.mw.Destroy()
}

func (suite *MaxDimensionTestSuite) TearDownSuite() {
	imagick.Terminate()
}

func (suite *MaxDimensionTestSuite) TestMaxWidth() {
	initialHeight := suite.mw.GetImageHeight()
	c := transformations.MaxWidth{10}
	err := ApplyTransformation(&c, suite.mw)
	suite.Require().NoError(err)

	suite.Require().Equal(suite.mw.GetImageWidth(), uint(10))
	suite.Require().Equal(suite.mw.GetImageHeight(), initialHeight)
}

func (suite *MaxDimensionTestSuite) TestMaxHeight() {
	initialWidth := suite.mw.GetImageWidth()
	c := transformations.MaxHeight{10}
	err := ApplyTransformation(&c, suite.mw)
	suite.Require().NoError(err)

	suite.Require().Equal(suite.mw.GetImageHeight(), uint(10))
	suite.Require().Equal(suite.mw.GetImageWidth(), initialWidth)
}

func TestMaxDimension(t *testing.T) {
	suite.Run(t, new(MaxDimensionTestSuite))
}
