package cwrapper

import (
	"code.justin.tv/web/upload-service/transformations"
	"gopkg.in/gographics/imagick.v2/imagick"
)

func ResizeDimensions(resize *transformations.ResizeDimensions, mw *imagick.MagickWand) error {
	curWidth := mw.GetImageWidth()
	curHeight := mw.GetImageHeight()
	filter := imagick.FILTER_LANCZOS

	newWidth := resize.Width
	newHeight := resize.Height

	if resize.Width == 0 {
		newWidth = uint(float64(curWidth) * float64(resize.Height) / float64(curHeight))
	} else if resize.Height == 0 {
		newHeight = uint(float64(curHeight) * float64(resize.Width) / float64(curWidth))
	}

	if newWidth > curWidth && newHeight > curHeight {
		filter = imagick.FILTER_MITCHELL
	}

	return mw.ResizeImage(newWidth, newHeight, filter, 1.0)
}

func pct(current uint, percent uint) uint {
	return uint(
		float64(percent) / 100.0 * float64(current),
	)
}

func ResizePercentage(resize *transformations.ResizePercentage, mw *imagick.MagickWand) error {
	curWidth := mw.GetImageWidth()
	curHeight := mw.GetImageHeight()
	filter := imagick.FILTER_LANCZOS
	if resize.Percent > 100 {
		filter = imagick.FILTER_MITCHELL
	}

	err := mw.ResizeImage(pct(curWidth, resize.Percent), pct(curHeight, resize.Percent), filter, 1.0)
	return err
}
