package cwrapper

import (
	"errors"

	"strings"

	"code.justin.tv/web/upload-service/rpc/uploader"
	"code.justin.tv/web/upload-service/transformations"
	"gopkg.in/gographics/imagick.v2/imagick"
)

func Transcode(t *transformations.Transcode, mw *imagick.MagickWand) error {
	err := mw.SetImageFormat(t.Format)
	if err != nil {
		return err
	}
	if mw.GetImageFormat() != t.Format {
		return errors.New("Failed to set image format: '" + t.Format + "'")
	}
	if t.Quality != 0 {
		err = mw.SetImageCompressionQuality(t.Quality)
	}

	if removeAlpha(t) {
		mw.SetImageAlphaChannel(imagick.ALPHA_CHANNEL_REMOVE)
	}

	return err
}

func removeAlpha(t *transformations.Transcode) bool {
	switch t.RemoveAlpha {
	case uploader.RemoveAlpha_FALSE:
		return false
	case uploader.RemoveAlpha_TRUE:
		return true
	default:
		format := strings.ToLower(t.Format)
		return format == "jpg" || format == "jpeg"
	}
}
