package cwrapper

import (
	"io/ioutil"
	"os"

	"testing"

	"code.justin.tv/web/upload-service/transformations"
	"github.com/stretchr/testify/suite"
)

type TransformationTestSuite struct {
	suite.Suite
	transformer *IMagickTransformer
}

func (suite *TransformationTestSuite) SetupSuite() {
	suite.transformer = &IMagickTransformer{}
	suite.transformer.Initialize()
}

func (suite *TransformationTestSuite) TearDownSuite() {
	suite.transformer.Terminate()
}

func (suite *TransformationTestSuite) TestRunTransformations() {
	transforms := []transformations.Transformation{
		&transformations.Transcode{Format: "png"},
		&transformations.ResizeDimensions{16, 17},
	}

	tmpDir, err := ioutil.TempDir("", "UPLOAD_ID")
	suite.Require().NoError(err)
	defer os.RemoveAll(tmpDir)

	info := transformations.NewFileInfo("UPLOAD_ID")
	result, err := suite.transformer.RunTransformations("../../test_images/me.jpg", tmpDir, "1", info, transforms)
	suite.Require().NoError(err)
	defer os.Remove(result.Name())

	suite.Require().Equal("png", info.Format)
	suite.Require().Equal(uint(16), info.Height)
	suite.Require().Equal(uint(17), info.Width)
}

func (suite *TransformationTestSuite) TestRunTransformationsFailure() {
	transforms := []transformations.Transformation{
		&transformations.Transcode{Format: "png"},
		&transformations.ResizeDimensions{16, 17},
	}

	tmpDir, err := ioutil.TempDir("", "UPLOAD_ID")
	suite.Require().NoError(err)
	defer os.RemoveAll(tmpDir)

	info := transformations.NewFileInfo("UPLOAD_ID")
	result, err := suite.transformer.RunTransformations("fake non existent file name", tmpDir, "1", info, transforms)
	suite.Require().Nil(result)
	suite.Require().Error(err)
}

func TestTransformation(t *testing.T) {
	suite.Run(t, new(TransformationTestSuite))
}
