package mocks

import mock "github.com/stretchr/testify/mock"
import os "os"
import transformations "code.justin.tv/web/upload-service/transformations"

// ImageTransformer is an autogenerated mock type for the ImageTransformer type
type ImageTransformer struct {
	mock.Mock
}

// FillInfoFromFile provides a mock function with given fields: tmpfile, info
func (_m *ImageTransformer) FillInfoFromFile(tmpfile *os.File, info *transformations.FileInfo) error {
	ret := _m.Called(tmpfile, info)

	var r0 error
	if rf, ok := ret.Get(0).(func(*os.File, *transformations.FileInfo) error); ok {
		r0 = rf(tmpfile, info)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Initialize provides a mock function with given fields:
func (_m *ImageTransformer) Initialize() {
	_m.Called()
}

// RunTransformations provides a mock function with given fields: filename, tmpDir, idx, info, _a4
func (_m *ImageTransformer) RunTransformations(filename string, tmpDir string, idx string, info *transformations.FileInfo, _a4 []transformations.Transformation) (*os.File, error) {
	ret := _m.Called(filename, tmpDir, idx, info, _a4)

	var r0 *os.File
	if rf, ok := ret.Get(0).(func(string, string, string, *transformations.FileInfo, []transformations.Transformation) *os.File); ok {
		r0 = rf(filename, tmpDir, idx, info, _a4)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*os.File)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, string, *transformations.FileInfo, []transformations.Transformation) error); ok {
		r1 = rf(filename, tmpDir, idx, info, _a4)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Terminate provides a mock function with given fields:
func (_m *ImageTransformer) Terminate() {
	_m.Called()
}
