package transformations

import (
	"os"

	"code.justin.tv/web/upload-service/rpc/uploader"
)

type Transformation interface {
	AsProto() *uploader.Transformation
}

// Reads and transforms images.
type ImageTransformer interface {
	// Setup method, called exactly once.
	Initialize()

	// Teardown method, called exactly once.
	Terminate()

	// Read `filename` and apply all the transformations in order. Write the output into `tmpDir/idx`.
	// Record metadata into the info struct.
	// Returns the output file.
	RunTransformations(filename, tmpDir, idx string, info *FileInfo, transformations []Transformation) (*os.File, error)

	// Fill the FileInfo struct with metadata from the given file.
	FillInfoFromFile(tmpfile *os.File, info *FileInfo) error
}
