# Pull Request Process

Thank you for contributing to Users Service! Please read all of this to have a successful PR experience. :tada:

1. **Review Criteria**: You'll find our Code Review Checklist below. This is an attempt to document everything we look in a PR. Spending time to ensure your branch meets those recommendations is a good way to reduce the time spent in code review.

1. **Build checks**: The PR can only be merged if all checks have passed. We have attempted to ensure the console output for all checks provide meaningful output. Let us know if any errors are confusing!

1. **Deploy to staging**:  Once your branch has built properly, deploy it to staging via [clean-deploy](https://clean-deploy.internal.justin.tv/#/web/users-service) and verify things work as expected. Before deploying, be sure that no one has deployed to staging within the last 30 minutes using [clean deploy's history page](https://clean-deploy.internal.justin.tv/#/web/users-service/history?env=staging&count=10). If someone has deployed within the last 30 minutes, reach out to them on slack to see if they are done using staging.

1. **Required Approval**: from a Users Service core member is needed before merging the PR (reachable in Slack #core-user). The Github UI currently allows anyone to approve, but please don't GitHub approve PRs if you are not a core user member. Feel encouraged to have a team member sanity check your PR and leave a thumbsup.

1. **72 hour SLA**: We have a 72 hour time-to-first-response SLA for all PRs (excluding weekends). If your branch is urgent (emergency bug fix or business critical feature release) please ping @userservices in #core-user with your PR number and an explanation of why the branch is urgent. Otherwise we'll automatically be alerted and review it as soon as we can, there is no need to manually post it or ping us.

1. **Never REBASE your branch**: It causes great pain to your code reviewer and may significantly delay the review of your PR. Feel free to merge master into your branch frequently, as all PRs are squash-merged and will end up as a single commit.

1. **Deploy to production-canary**: Deploy to production-canary BEFORE merging to master using [clean-deploy](https://clean-deploy.internal.justin.tv/#/web/users-service). Before deploying, be sure that no one has deployed to staging within the last 30 minutes using [clean deploy's history page](https://clean-deploy.internal.justin.tv/#/web/users-service/history?env=production-canary&count=10). If someone has deployed within the last 30 minutes, reach out to them on slack to see if they are done using canary.
You can monitor for canary errors via [Rollbar](https://rollbar.com/Twitch/Users/) and [Grafana](https://grafana.internal.justin.tv/dashboard/db/users-service?from=now-30m&to=now-1m&var-env=production&var-host=users-service-aws-08cd5c6efa809d8ec&refresh=1m&orgId=1)

1. **Merge to master**: Once above steps are complete, merge to master.

1. **Deploy to Production**: Deploy to Production right after you merge your branch to master using [clean-deploy](https://clean-deploy.internal.justin.tv/#/web/users-service). It is not acceptable to have undeployed commits in master. In case you merged and realized that it is not a good time to deploy (e.g code freeze), please revert your commit(s). **NOTE: Continuous deployment does not exist yet so you must deploy your code manually**

1. **Monitor your deploy**: Use [Grafana](https://grafana.internal.justin.tv/dashboard/db/users-service-availability-and-latency?refresh=30s&orgId=1&from=now-3h&to=now-1m) and [Rollbar](https://rollbar.com/Twitch/Users/) to monitor your deploy and ensure no anomalies show up.

If you have any questions during this process or advice on how to make it better, please let us know in #core-user. Thank you for your patience and cooperation!

# Code Review Checklist

1. Tests should pass! See [How to run the tests](README.md#testing).
2. Changes affecting the API should be reflected in the [users client](client/usersservice.go), the [channels client](client/channels/client.go), and the [**API DOCUMENTATION**](doc/api.md). These changes should be **backwards compatible** unless due dilligence is done.

