# Users Service

Users Service provides property access and business logic for core "user" properties

## API

Staging: https://users-service.dev.us-west2.twitch.tv

Prod: https://users-service.prod.us-west2.twitch.tv

Please see the [API documentation](doc/api.md).

## Dashboards

Please see the [dashboard documentation](doc/dashboards.md).

## Accessing Users Service

Users Service's production environment is currently restricted to access from Twitch EC2 instances. This means you can rest assured that https://users-service.prod.us-west2.twitch.tv is accessible from within your production service's networks. 99% of the time, you should be hitting users's service staging environment with your local environment.

However, if you do need to access user service's production environment for local development of services that are dependent, one option is to run a local port forward via an existing ec2 instance in staging.

e.g.

    ssh -L 9999:users-service.prod.us-west2.twitch.tv:80 <hostnameofanec2instanceinstaging>

This will then allow you to hit http://localhost:9999/users?id=1 and other endpoints from your local environment. For maximum convenience, maybe run this in a tmux session and detatch.

**Please do not create any persistent shims to users service that don't require some form of secure authentication. For example, SSH can be made to expose a port forward globally from one of your ec2 instances so that all local devs could just hit that and never run their own tunnel. This defeats the purpose of gating users service access outside of AWS behind SSH authentication and opens Twitch up to security issues.**

## Build

    go build

I'd recommend you use `make test-in-ci` for building however the above will
produce a users-service binary you can use.

## Testing

Unit tests can be run as follows

	go test ./...
	
Integration tests rely on docker:

	make test-in-ci
	
If the tests run slowly, increase the memory and CPU allocated to your local docker instance.

Test coverage is significantly less than 100% and should be used as supplemental not exclusive testing. To see test coverage results in your browser, run:

    make show-coverage

Mocks were created using

https://github.com/vektra/mockery

To regenerate do something like

    go get github.com/vektra/mockery/...
    go generate ./...

If the mocks fail to generate because of a `common/twitchhttp` issue

    pushd $GOPATH/src/code.justin.tv/common/twitchhttp
    git fetch origin
    git checkout serverless
    popd
    # Generate mocks again
    go generate ./...

## How to run

Install [docker](https://www.docker.com/docker-mac) and [docker-compose](https://docs.docker.com/compose/install/).

```bash
docker-compose up -d db redis

docker-compose build
docker-compose up -d server worker
```

This will run a local copy against a local redis and database.

If you need to generate the dump files again please do the following
against a staging database (from the project root):

    pg_dump -xOs -h master-sitedb.staging.sfo01.justin.tv -p 6543 -U site_02 justintv_dev -t users -t user_moderation_properties -t user_role_properties -t user_email_properties -t user_phone_number_properties > db-data/01_schema_dump.sql
    psql -h master-sitedb.staging.sfo01.justin.tv -p 6543 -U site_02 justintv_dev < build/dumper.sql

## Development - Mac OS X

Install [docker](https://www.docker.com/docker-mac) and [docker-compose](https://docs.docker.com/compose/install/).

To run our test suite (linting, unit tests, integration tests):

```bash
make test-in-ci
```

If you want to specifically run the integration tests, use:

```bash
make integrationtest
```


Install GeoIP db:

```bash
brew install geoip pkg-config
wget -N http://geolite.maxmind.com/download/geoip/database/GeoLiteCountry/GeoIP.dat.gz
gunzip GeoIP.dat.gz
mkdir -p /usr/share/GeoIP/
mv GeoIP.dat /usr/share/GeoIP/
```

Then, to run the server:

```bash
echo localhost:5432:users:users > .dbpass_dev
./users-service
// you should now be able to access the users-service running in vagrant from your dev environment at localhost:8080
// you will likely need to install, configure, and load database dumps for postgres / redis
```

### Updating the docker image

To build and push a new docker image, run:
```
docker build -t "docker-registry.internal.justin.tv/web/users-service-build:latest" -f build.Dockerfile .
docker push docker-registry.internal.justin.tv/web/users-service-build:latest
```

## Run terraform

Terraform versions are defined in `.terraform_version` files. [chtf](https://github.com/Yleisradio/homebrew-terraforms#chtf---terraform-version-switcher) is recommended to switch between versions with `chtf $(cat .terraform_version)`. Terraform directories with <0.9 require running bootstrap.sh and setting `AWS_PROFILE`. The bootstrap script will set up remote state, grab everything updated to prepare for your runs. In new versions of terraform, this is no required. It is helpful to submit a pr with your terraform plan result before actually running on prod.

Run terraform for prod (under `terraform/production/us-west-2`):
```
chtf $(cat .terraform_version)
AWS_PROFILE=twitch-web-aws AWS_DEFAULT_REGION=us-west-2 sh bootstrap.sh
AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-web-aws terraform plan --out=foo
AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-web-aws terraform apply foo
```

Run terraform for prod beanstalk (under `terraform/production/us-west-2`):
```
chtf $(cat .terraform_version)
terraform plan --out=foo
terraform apply foo
```

Run terraform for staging (under `terraform/staging/us-west-2`):
```
chtf $(cat .terraform_version)
AWS_PROFILE=twitch-web-dev AWS_DEFAULT_REGION=us-west-2 sh bootstrap.sh
AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-web-dev terraform plan --out=foo
AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-web-dev terraform apply foo
```

## Update vendor
Users-service is using glide to do vendoring. Add your new vendor to glide.yaml file.

Then run a vendor update
```
make vendor
```

If `make vendor` fails due to a specific mock, delete that existing mock file and then rerun `make vendor`.

## Generate default image binary data
We are using [go-bindata](https://github.com/jteeuwen/go-bindata) to generate default image file located inside internal/image/data directory. You will want regenerate [image directory](https://git-aws.internal.justin.tv/web/users-service/tree/master/internal/image/data) when you have any changes to the content of the image json files.
 
To regenerate the [imagedata.go](https://git-aws.internal.justin.tv/web/users-service/tree/master/internal/image/data/imagedata.go), please do

```
go get -u github.com/jteeuwen/go-bindata/...
cd internal/image/data
go-bindata -o ../imagedata.go .
```

## Accounts per email limitation
We are introducing a new feature to limit accounts per email, the current limit is 25. And we whitelisted all staff email address domain and QA used testing emails. 

If you are trying signup flow, we recommend you use staff email domain (twitch/justin) or use "+" after your email. For example, if your email 123@gmail.com is throttled because of too many accounts associated, you could use 123+testing@gmail.com to bypass the email limitation checking.


