package redis

import "github.com/stretchr/testify/mock"

import "time"

import "golang.org/x/net/context"

// @generated

type MockRedis struct {
	mock.Mock
}

// Key provides a mock function with given fields: _a0
func (_m *MockRedis) Key(_a0 string) string {
	ret := _m.Called(_a0)

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// Keys provides a mock function with given fields: ctx, pattern
func (_m *MockRedis) Keys(ctx context.Context, pattern string) ([]string, error) {
	ret := _m.Called(ctx, pattern)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, string) []string); ok {
		r0 = rf(ctx, pattern)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, pattern)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Incr provides a mock function with given fields: ctx, key, ttl
func (_m *MockRedis) Incr(ctx context.Context, key string, ttl time.Duration) (int64, error) {
	ret := _m.Called(ctx, key, ttl)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, string, time.Duration) int64); ok {
		r0 = rf(ctx, key, ttl)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, time.Duration) error); ok {
		r1 = rf(ctx, key, ttl)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RateIncr provides a mock function with given fields: ctx, key, duration
func (_m *MockRedis) RateIncr(ctx context.Context, key string, duration time.Duration) (int64, error) {
	ret := _m.Called(ctx, key, duration)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, string, time.Duration) int64); ok {
		r0 = rf(ctx, key, duration)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, time.Duration) error); ok {
		r1 = rf(ctx, key, duration)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SafeCache provides a mock function with given fields: ctx, key, value, ttl
func (_m *MockRedis) SafeCache(ctx context.Context, key string, value string, ttl time.Duration) error {
	ret := _m.Called(ctx, key, value, ttl)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, time.Duration) error); ok {
		r0 = rf(ctx, key, value, ttl)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SafeSetWithTTL provides a mock function with given fields: ctx, key, value, ttl
func (_m *MockRedis) SafeSetWithTTL(ctx context.Context, key string, value string, ttl time.Duration) (bool, error) {
	ret := _m.Called(ctx, key, value, ttl)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, string, time.Duration) bool); ok {
		r0 = rf(ctx, key, value, ttl)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, time.Duration) error); ok {
		r1 = rf(ctx, key, value, ttl)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MSafeSetWithTTL provides a mock function with given fields: ctx, keys, values, ttl
func (_m *MockRedis) MSafeSetWithTTL(ctx context.Context, keys []string, values []string, ttl time.Duration) ([]bool, error) {
	ret := _m.Called(ctx, keys, values, ttl)

	var r0 []bool
	if rf, ok := ret.Get(0).(func(context.Context, []string, []string, time.Duration) []bool); ok {
		r0 = rf(ctx, keys, values, ttl)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]bool)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string, []string, time.Duration) error); ok {
		r1 = rf(ctx, keys, values, ttl)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetWithTTL provides a mock function with given fields: ctx, key, value, ttl
func (_m *MockRedis) SetWithTTL(ctx context.Context, key string, value string, ttl time.Duration) error {
	ret := _m.Called(ctx, key, value, ttl)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, time.Duration) error); ok {
		r0 = rf(ctx, key, value, ttl)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MSetWithTTL provides a mock function with given fields: ctx, keys, values, ttl
func (_m *MockRedis) MSetWithTTL(ctx context.Context, keys []string, values []string, ttl time.Duration) error {
	ret := _m.Called(ctx, keys, values, ttl)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, []string, []string, time.Duration) error); ok {
		r0 = rf(ctx, keys, values, ttl)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Get provides a mock function with given fields: ctx, key
func (_m *MockRedis) Get(ctx context.Context, key string) (string, bool, error) {
	ret := _m.Called(ctx, key)

	var r0 string
	if rf, ok := ret.Get(0).(func(context.Context, string) string); ok {
		r0 = rf(ctx, key)
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(context.Context, string) bool); ok {
		r1 = rf(ctx, key)
	} else {
		r1 = ret.Get(1).(bool)
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string) error); ok {
		r2 = rf(ctx, key)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// ClusterSafeMGet provides a mock function with given fields: ctx, keys
func (_m *MockRedis) ClusterSafeMGet(ctx context.Context, keys ...string) ([]string, error) {
	ret := _m.Called(ctx, keys)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, ...string) []string); ok {
		r0 = rf(ctx, keys...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, ...string) error); ok {
		r1 = rf(ctx, keys...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MGet provides a mock function with given fields: ctx, keys
func (_m *MockRedis) MGet(ctx context.Context, keys ...string) ([]string, error) {
	ret := _m.Called(ctx, keys)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, ...string) []string); ok {
		r0 = rf(ctx, keys...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, ...string) error); ok {
		r1 = rf(ctx, keys...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Hmget provides a mock function with given fields: ctx, hash, keys
func (_m *MockRedis) Hmget(ctx context.Context, hash string, keys ...string) ([]string, error) {
	ret := _m.Called(ctx, hash, keys)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, string, ...string) []string); ok {
		r0 = rf(ctx, hash, keys...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, ...string) error); ok {
		r1 = rf(ctx, hash, keys...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Del provides a mock function with given fields: ctx, keys
func (_m *MockRedis) Del(ctx context.Context, keys ...string) (int, error) {
	ret := _m.Called(ctx, keys)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, ...string) int); ok {
		r0 = rf(ctx, keys...)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, ...string) error); ok {
		r1 = rf(ctx, keys...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Ttl provides a mock function with given fields: ctx, key
func (_m *MockRedis) Ttl(ctx context.Context, key string) (int, error) {
	ret := _m.Called(ctx, key)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string) int); ok {
		r0 = rf(ctx, key)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Expire provides a mock function with given fields: ctx, key, ttl
func (_m *MockRedis) Expire(ctx context.Context, key string, ttl time.Duration) error {
	ret := _m.Called(ctx, key, ttl)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, time.Duration) error); ok {
		r0 = rf(ctx, key, ttl)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// LPush provides a mock function with given fields: ctx, key, value
func (_m *MockRedis) LPush(ctx context.Context, key string, value string) (uint64, error) {
	ret := _m.Called(ctx, key, value)

	var r0 uint64
	if rf, ok := ret.Get(0).(func(context.Context, string, string) uint64); ok {
		r0 = rf(ctx, key, value)
	} else {
		r0 = ret.Get(0).(uint64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, key, value)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// LTrim provides a mock function with given fields: ctx, key, start, end
func (_m *MockRedis) LTrim(ctx context.Context, key string, start int64, end int64) error {
	ret := _m.Called(ctx, key, start, end)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, int64, int64) error); ok {
		r0 = rf(ctx, key, start, end)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// LRange provides a mock function with given fields: ctx, key, start, end
func (_m *MockRedis) LRange(ctx context.Context, key string, start int64, end int64) ([]string, error) {
	ret := _m.Called(ctx, key, start, end)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, string, int64, int64) []string); ok {
		r0 = rf(ctx, key, start, end)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, int64, int64) error); ok {
		r1 = rf(ctx, key, start, end)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// LRem provides a mock function with given fields: ctx, key, count, item
func (_m *MockRedis) LRem(ctx context.Context, key string, count int64, item string) (int, error) {
	ret := _m.Called(ctx, key, count, item)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string, int64, string) int); ok {
		r0 = rf(ctx, key, count, item)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, int64, string) error); ok {
		r1 = rf(ctx, key, count, item)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Sadd provides a mock function with given fields: ctx, key, item
func (_m *MockRedis) Sadd(ctx context.Context, key string, item string) (int, error) {
	ret := _m.Called(ctx, key, item)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string, string) int); ok {
		r0 = rf(ctx, key, item)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, key, item)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Srem provides a mock function with given fields: ctx, key, item
func (_m *MockRedis) Srem(ctx context.Context, key string, item string) (int, error) {
	ret := _m.Called(ctx, key, item)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string, string) int); ok {
		r0 = rf(ctx, key, item)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, key, item)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Scard provides a mock function with given fields: ctx, key
func (_m *MockRedis) Scard(ctx context.Context, key string) (int, error) {
	ret := _m.Called(ctx, key)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string) int); ok {
		r0 = rf(ctx, key)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Smembers provides a mock function with given fields: ctx, key
func (_m *MockRedis) Smembers(ctx context.Context, key string) ([]string, error) {
	ret := _m.Called(ctx, key)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, string) []string); ok {
		r0 = rf(ctx, key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Zadd provides a mock function with given fields: ctx, key, score, item
func (_m *MockRedis) Zadd(ctx context.Context, key string, score int64, item string) (int, error) {
	ret := _m.Called(ctx, key, score, item)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string, int64, string) int); ok {
		r0 = rf(ctx, key, score, item)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, int64, string) error); ok {
		r1 = rf(ctx, key, score, item)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Zcard provides a mock function with given fields: ctx, key
func (_m *MockRedis) Zcard(ctx context.Context, key string) (int, error) {
	ret := _m.Called(ctx, key)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string) int); ok {
		r0 = rf(ctx, key)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Zrem provides a mock function with given fields: ctx, key, item
func (_m *MockRedis) Zrem(ctx context.Context, key string, item string) (int, error) {
	ret := _m.Called(ctx, key, item)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string, string) int); ok {
		r0 = rf(ctx, key, item)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, key, item)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Zrangebyscore provides a mock function with given fields: ctx, key, min, max
func (_m *MockRedis) Zrangebyscore(ctx context.Context, key string, min int64, max int64) ([]string, error) {
	ret := _m.Called(ctx, key, min, max)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, string, int64, int64) []string); ok {
		r0 = rf(ctx, key, min, max)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, int64, int64) error); ok {
		r1 = rf(ctx, key, min, max)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Zremrangebyscore provides a mock function with given fields: ctx, key, fromScore, toScore
func (_m *MockRedis) Zremrangebyscore(ctx context.Context, key string, fromScore int, toScore int) (int, error) {
	ret := _m.Called(ctx, key, fromScore, toScore)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string, int, int) int); ok {
		r0 = rf(ctx, key, fromScore, toScore)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, int, int) error); ok {
		r1 = rf(ctx, key, fromScore, toScore)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Eval provides a mock function with given fields: ctx, script, keys, args, stat
func (_m *MockRedis) Eval(ctx context.Context, script string, keys []interface{}, args []interface{}, stat string) (interface{}, error) {
	ret := _m.Called(ctx, script, keys, args, stat)

	var r0 interface{}
	if rf, ok := ret.Get(0).(func(context.Context, string, []interface{}, []interface{}, string) interface{}); ok {
		r0 = rf(ctx, script, keys, args, stat)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(interface{})
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, []interface{}, []interface{}, string) error); ok {
		r1 = rf(ctx, script, keys, args, stat)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Close provides a mock function with given fields:
func (_m *MockRedis) Close() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
