package documents

import "code.justin.tv/growth/emailvalidator/models"

// VerificationRequestDocument provides the JSON representation of a
// verification request that we return to the caller
type VerificationRequestDocument struct {
	Namespace string `json:"namespace"`
	Key       string `json:"key"`
	Email     string `json:"email"`
	OpaqueID  string `json:"opaque_id"`
	Status    string `json:"status"`
	Locale    string `json:"locale"`
}

// NewVerificationRequestDocument constructs a verification request
// document from the model
func NewVerificationRequestDocument(request *models.VerificationRequest) *VerificationRequestDocument {
	return &VerificationRequestDocument{
		Namespace: request.Namespace,
		Key:       request.Key,
		Email:     request.Email,
		OpaqueID:  request.OpaqueID,
		Status:    models.StatusString(request.Status),
		Locale:    request.Locale,
	}
}
